/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.baseline.detector.impl;

import org.eclipse.chemclipse.chromatogram.xxd.baseline.detector.core.AbstractBaselineDetector;
import org.eclipse.chemclipse.chromatogram.xxd.baseline.detector.impl.DetectorSettings;
import org.eclipse.chemclipse.chromatogram.xxd.baseline.detector.settings.IBaselineDetectorSettings;
import org.eclipse.chemclipse.model.baseline.IBaselineModel;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.core.runtime.IProgressMonitor;

public class BaselineDetector
extends AbstractBaselineDetector {
    @Override
    public IProcessingInfo setBaseline(IChromatogramSelection chromatogramSelection, IBaselineDetectorSettings baselineDetectorSettings, IProgressMonitor monitor) {
        float intensity;
        IProcessingInfo processingInfo = super.validate(chromatogramSelection, baselineDetectorSettings, monitor);
        if (!processingInfo.hasErrorMessages() && baselineDetectorSettings instanceof DetectorSettings && (intensity = this.extractLowestIntensity(chromatogramSelection)) != 0.0f) {
            IChromatogram chromatogram = chromatogramSelection.getChromatogram();
            IBaselineModel baselineModel = chromatogram.getBaselineModel();
            int startRetentionTime = chromatogramSelection.getStartRetentionTime();
            int stopRetentionTime = chromatogramSelection.getStopRetentionTime();
            float startBackgroundAbundance = intensity;
            float stopBackgroundAbundance = intensity;
            baselineModel.addBaseline(startRetentionTime, stopRetentionTime, startBackgroundAbundance, stopBackgroundAbundance, false);
        }
        return processingInfo;
    }

    @Override
    public IProcessingInfo setBaseline(IChromatogramSelection chromatogramSelection, IProgressMonitor monitor) {
        DetectorSettings settings = new DetectorSettings();
        return this.setBaseline(chromatogramSelection, settings, monitor);
    }

    private float extractLowestIntensity(IChromatogramSelection chromatogramSelection) {
        IChromatogram chromatogram = chromatogramSelection.getChromatogram();
        int scanStart = chromatogramSelection.getStartScan();
        int scanStop = chromatogramSelection.getStopScan();
        float intensity = 0.0f;
        if (scanStart > 0 && scanStop > 0) {
            intensity = Float.MAX_VALUE;
            int i = scanStart;
            while (i <= scanStop) {
                IScan scan = chromatogram.getScan(i);
                intensity = Math.min(intensity, scan.getTotalSignal());
                ++i;
            }
        }
        return intensity;
    }
}

