/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.filter.supplier.xpass.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.chromatogram.msd.filter.core.massspectrum.AbstractMassSpectrumFilter;
import org.eclipse.chemclipse.chromatogram.msd.filter.result.IMassSpectrumFilterResult;
import org.eclipse.chemclipse.chromatogram.msd.filter.settings.IMassSpectrumFilterSettings;
import org.eclipse.chemclipse.chromatogram.msd.filter.supplier.xpass.settings.CutOfMassSpectrumFilterSettings;
import org.eclipse.chemclipse.msd.model.core.IIon;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.core.runtime.IProgressMonitor;

public class CutOfMassSpectrumFilter
extends AbstractMassSpectrumFilter {
    public IProcessingInfo<IMassSpectrumFilterResult> applyFilter(List<IScanMSD> massSpectra, IMassSpectrumFilterSettings massSpectrumFilterSettings, IProgressMonitor monitor) {
        CutOfMassSpectrumFilterSettings settings = massSpectrumFilterSettings instanceof CutOfMassSpectrumFilterSettings ? (CutOfMassSpectrumFilterSettings)massSpectrumFilterSettings : new CutOfMassSpectrumFilterSettings();
        for (IScanMSD massSpectrum : massSpectra) {
            ArrayList ions = new ArrayList(massSpectrum.getIons());
            for (IIon ion : ions) {
                if (!(ion.getAbundance() < (float)settings.getThreshold())) continue;
                massSpectrum.removeIon(ion);
                massSpectrum.setDirty(true);
            }
        }
        return null;
    }
}

