/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.converter.model;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.support.settings.OperatingSystemUtils;

public class SeparationColumnMapping
extends HashMap<String, String> {
    private static final long serialVersionUID = -7471629528422149178L;
    private static final Logger logger = Logger.getLogger(SeparationColumnMapping.class);
    public static final String SEPARATOR_TOKEN = ";";
    public static final String SEPARATOR_ENTRY = "|";

    public void load(String items) {
        this.loadSettings(items);
    }

    public void loadDefault(String items) {
        this.loadSettings(items);
    }

    public String save() {
        return this.extractSettings(this);
    }

    public String extractSettings(Map<String, String> settings) {
        StringBuilder builder = new StringBuilder();
        Iterator<Map.Entry<String, String>> iterator = settings.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> setting = iterator.next();
            builder.append(setting.getKey());
            builder.append(SEPARATOR_ENTRY);
            builder.append(setting.getValue());
            if (!iterator.hasNext()) continue;
            builder.append(SEPARATOR_TOKEN);
        }
        return builder.toString().trim();
    }

    public void importItems(File file) {
        try {
            Throwable throwable = null;
            Object var3_6 = null;
            try (BufferedReader bufferedReader = new BufferedReader(new FileReader(file));){
                String line;
                while ((line = bufferedReader.readLine()) != null) {
                    String[] parsedItems = this.parseString(line.trim());
                    if (parsedItems.length <= 0) continue;
                    String[] stringArray = parsedItems;
                    int n = parsedItems.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String item = stringArray[n2];
                        this.addItem(item);
                        ++n2;
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException e) {
            logger.warn((Object)e);
        }
        catch (IOException e) {
            logger.warn((Object)e);
        }
    }

    public boolean exportItems(File file) {
        try {
            PrintWriter printWriter = new PrintWriter(file);
            printWriter.println(this.extractSettings(this));
            printWriter.flush();
            printWriter.close();
            return true;
        }
        catch (FileNotFoundException e) {
            logger.warn((Object)e);
            return false;
        }
    }

    private void loadSettings(String items) {
        String[] parsedItems;
        if (!"".equals(items) && (parsedItems = this.parseString(items)).length > 0) {
            String[] stringArray = parsedItems;
            int n = parsedItems.length;
            int n2 = 0;
            while (n2 < n) {
                String item = stringArray[n2];
                this.addItem(item);
                ++n2;
            }
        }
    }

    private void addItem(String item) {
        String[] values = item.split("\\|");
        if (values.length == 2) {
            this.put(values[0].trim(), values[1].trim());
        }
    }

    private String[] parseString(String stringList) {
        String lineDelimiterSpecific = OperatingSystemUtils.getLineDelimiter();
        String lineDelimiterGeneric = "\n";
        String[] decodedArray = stringList.contains(SEPARATOR_TOKEN) ? stringList.split(SEPARATOR_TOKEN) : (stringList.contains(lineDelimiterSpecific) ? stringList.split(lineDelimiterSpecific) : (stringList.contains(lineDelimiterGeneric) ? stringList.split(lineDelimiterGeneric) : new String[]{stringList}));
        return decodedArray;
    }
}

