/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.converter.adapters;

import java.io.File;
import org.eclipse.chemclipse.converter.methods.MethodConverter;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.methods.IProcessMethod;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class MethodAdapterFactory
implements IAdapterFactory {
    public <T> T getAdapter(Object adaptableObject, Class<T> adapterType) {
        if (adapterType == IProcessMethod.class) {
            if (adaptableObject instanceof IFile) {
                File localfile;
                IFile resourceFile = (IFile)adaptableObject;
                IPath location = resourceFile.getLocation();
                if (location != null && (localfile = location.toFile()).exists()) {
                    return adapterType.cast(this.convertFile(localfile));
                }
            } else if (adaptableObject instanceof File) {
                return adapterType.cast(this.convertFile((File)adaptableObject));
            }
        }
        return null;
    }

    public IProcessMethod convertFile(File localfile) {
        IProcessingInfo<IProcessMethod> processingInfo = MethodConverter.convert(localfile, (IProgressMonitor)new NullProgressMonitor());
        if (processingInfo != null) {
            return (IProcessMethod)processingInfo.getProcessingResult();
        }
        return null;
    }

    public Class<?>[] getAdapterList() {
        return new Class[]{IProcessMethod.class};
    }
}

