/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.calculator.supplier.amdiscalri.ui.internal.runnables;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.supplier.amdiscalri.impl.AlkanePatternDetectorCSD;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.supplier.amdiscalri.impl.AlkanePatternDetectorMSD;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.supplier.amdiscalri.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.supplier.amdiscalri.ui.wizards.IRetentionIndexWizardElements;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class ChromatogramImportRunnable
implements IRunnableWithProgress {
    private IRetentionIndexWizardElements wizardElements;
    private IChromatogram<? extends IPeak> chromatogram;

    public ChromatogramImportRunnable(IRetentionIndexWizardElements wizardElements) {
        this.wizardElements = wizardElements;
    }

    public IChromatogram<? extends IPeak> getChromatogram() {
        return this.chromatogram;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        String pathRetentionIndexFile = "";
        if (this.wizardElements.isUseExistingRetentionIndexFile()) {
            pathRetentionIndexFile = this.wizardElements.getPathRetentionIndexFile();
        }
        boolean useAlreadyDetectedPeaks = this.wizardElements.isUseAlreadyDetectedPeaks();
        if (this.wizardElements.isUseMassSpectrometryData()) {
            String chromatogramPath = (String)this.wizardElements.getSelectedChromatograms().get(0);
            AlkanePatternDetectorMSD alkanePatternDetector = new AlkanePatternDetectorMSD();
            this.chromatogram = alkanePatternDetector.parseChromatogram(chromatogramPath, pathRetentionIndexFile, useAlreadyDetectedPeaks, monitor);
            File file = new File(chromatogramPath);
            PreferenceSupplier.setFilterPathModelsMSD((String)file.getParentFile().getAbsolutePath());
        } else {
            String chromatogramPath = (String)this.wizardElements.getSelectedChromatograms().get(0);
            AlkanePatternDetectorCSD alkanePatternDetector = new AlkanePatternDetectorCSD();
            this.chromatogram = alkanePatternDetector.parseChromatogram(chromatogramPath, pathRetentionIndexFile, useAlreadyDetectedPeaks, monitor);
            File file = new File(chromatogramPath);
            PreferenceSupplier.setFilterPathModelsCSD((String)file.getParentFile().getAbsolutePath());
        }
    }
}

