/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.rcp.app.ui.provider;

import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class SelectViewFilter
extends ViewerFilter {
    private static final Logger logger = Logger.getLogger(SelectViewFilter.class);
    private String searchPattern;
    private boolean caseInsensitive;

    public void setCaseInsensitive(boolean caseInsensitive) {
        this.caseInsensitive = caseInsensitive;
    }

    public boolean isCaseInsensitive() {
        return this.caseInsensitive;
    }

    public void setSearchPattern(String searchPattern) {
        this.searchPattern = this.caseInsensitive ? searchPattern.toLowerCase() : searchPattern;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (this.searchPattern == null || this.searchPattern.equals("")) {
            return true;
        }
        if (element instanceof MPart) {
            MPart part = (MPart)element;
            String partLabel = part.getLabel();
            if (partLabel != null) {
                String label;
                String string = label = this.caseInsensitive ? partLabel.toLowerCase() : partLabel;
                if (label.contains(this.searchPattern)) {
                    return true;
                }
            } else {
                logger.warn((Object)("Please add a part label: " + part.getElementId()));
            }
        }
        return false;
    }
}

