/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.rcp.app.ui.handlers;

import java.util.List;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import javax.inject.Named;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MSnippetContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MStackElement;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.swt.widgets.Display;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class OpenSnippetHandler {
    private static final String SNIPPT_PARAMETER = "org.eclipse.chemclipse.rcp.app.ui.commandparameter.opensnippet.snippetid";

    @Execute
    public void execute(@Named(value="org.eclipse.chemclipse.rcp.app.ui.commandparameter.opensnippet.snippetid") String snippetId, EPartService partService, MApplication application, EModelService modelService) {
        OpenSnippetHandler.openSnippet(snippetId, application, modelService, partService);
    }

    @CanExecute
    public boolean canExecute(@Named(value="org.eclipse.chemclipse.rcp.app.ui.commandparameter.opensnippet.snippetid") String snippetId, MApplication application, EModelService modelService) {
        return modelService.findSnippet((MSnippetContainer)application, snippetId) != null;
    }

    public static void openSnippet(String snippetId, MApplication application, EModelService modelService, EPartService partService) {
        OpenSnippetHandler.openSnippet(snippetId, application, modelService, partService, "org.eclipse.e4.primaryDataStack");
    }

    public static void openSnippet(String snippetId, MApplication application, EModelService modelService, EPartService partService, String stackId) {
        OpenSnippetHandler.addToEditorStack(modelService, stackId, (MUIElement)application).andThen(OpenSnippetHandler.openPart(partService)).accept((MUIElement)OpenSnippetHandler.cloneSnippet(snippetId, modelService, (MSnippetContainer)application));
    }

    public static void openSnippet(String snippetId, IEclipseContext eclipseContext, BiFunction<IEclipseContext, MPart, Runnable> childContextInitializer) {
        OpenSnippetHandler.openSnippet(snippetId, eclipseContext, "org.eclipse.e4.primaryDataStack", childContextInitializer);
    }

    public static void openSnippet(String snippetId, IEclipseContext eclipseContext, String stackId, BiFunction<IEclipseContext, MPart, Runnable> childContextInitializer) {
        MApplication application = (MApplication)eclipseContext.get(MApplication.class);
        EModelService modelService = (EModelService)eclipseContext.get(EModelService.class);
        EPartService partService = (EPartService)eclipseContext.get(EPartService.class);
        OpenSnippetHandler.withEclipseContext(eclipseContext, childContextInitializer).andThen(OpenSnippetHandler.addToEditorStack(modelService, stackId, (MUIElement)application)).andThen(OpenSnippetHandler.openPart(partService)).accept((MUIElement)OpenSnippetHandler.cloneSnippet(snippetId, modelService, (MSnippetContainer)application));
    }

    public static void openCompositeSnippet(String snippetId, IEclipseContext eclipseContext, BiFunction<IEclipseContext, MPart, Runnable> childContextInitializer) {
        OpenSnippetHandler.openCompositeSnippet(snippetId, eclipseContext, "org.eclipse.e4.primaryDataStack", childContextInitializer);
    }

    public static void openCompositeSnippet(String snippetId, IEclipseContext eclipseContext, String stackId, BiFunction<IEclipseContext, MPart, Runnable> childContextInitializer) {
        MApplication application = (MApplication)eclipseContext.get(MApplication.class);
        EModelService modelService = (EModelService)eclipseContext.get(EModelService.class);
        EPartService partService = (EPartService)eclipseContext.get(EPartService.class);
        OpenSnippetHandler.withEclipseContext(eclipseContext, childContextInitializer).andThen(OpenSnippetHandler.addToEditorStack(modelService, stackId, (MUIElement)application)).andThen(OpenSnippetHandler.disableMove()).andThen(OpenSnippetHandler.openPart(partService)).andThen(OpenSnippetHandler.activateAll(partService)).andThen(OpenSnippetHandler.focusPart(partService)).accept((MUIElement)OpenSnippetHandler.cloneSnippet(snippetId, modelService, (MSnippetContainer)application));
    }

    public static Consumer<MUIElement> addToEditorStack(EModelService modelService, String stackID, MUIElement searchRoot) {
        return element -> {
            if (element instanceof MStackElement) {
                MStackElement stackElement = (MStackElement)element;
                MUIElement partStack = modelService.find(stackID, searchRoot);
                if (partStack instanceof MPartStack) {
                    ((MPartStack)partStack).getChildren().add(stackElement);
                }
            }
        };
    }

    public static Consumer<MUIElement> disableMove() {
        return element -> {
            if (element instanceof MElementContainer) {
                List children = ((MElementContainer)element).getChildren();
                for (Object child : children) {
                    if (!(child instanceof MUIElement)) continue;
                    MUIElement mui = (MUIElement)child;
                    if (child instanceof MPart) {
                        mui.getTags().add("NoMove");
                    }
                    OpenSnippetHandler.disableMove().accept(mui);
                }
            }
        };
    }

    public static Consumer<MUIElement> withEclipseContext(final IEclipseContext parent, final BiFunction<IEclipseContext, MPart, Runnable> childContextInitializer) {
        if (parent == null) {
            throw new IllegalArgumentException("IEclipseContext can't be null");
        }
        return new Consumer<MUIElement>(){

            @Override
            public void accept(MUIElement element) {
                final IEclipseContext child = parent.createChild(String.valueOf(element.getElementId()) + ".composite");
                if (element instanceof MPart) {
                    MPart part = (MPart)element;
                    part.setContext(child);
                    child.set(MPart.class, (Object)part);
                    final Runnable runnable = childContextInitializer != null ? (Runnable)childContextInitializer.apply(child, part) : null;
                    OpenSnippetHandler.onClose((IEventBroker)parent.get(IEventBroker.class), new Runnable(){

                        @Override
                        public void run() {
                            try {
                                if (runnable != null) {
                                    runnable.run();
                                }
                            }
                            finally {
                                child.dispose();
                            }
                        }
                    });
                }
            }
        };
    }

    public static <T extends MUIElement> T cloneSnippet(String snippetId, EModelService modelService, MSnippetContainer snippetContainer) {
        MUIElement snippet = modelService.cloneSnippet(snippetContainer, snippetId, null);
        if (snippet == null) {
            throw new IllegalArgumentException("snippet with id " + snippetId + " was not found in container " + snippetContainer);
        }
        snippet.getTags().add("removeOnHide");
        snippet.setElementId(String.valueOf(snippetId) + "." + UUID.randomUUID().toString());
        return (T)snippet;
    }

    public static Consumer<MUIElement> activateAll(EPartService partService) {
        return element -> {
            if (element instanceof MPart) {
                MPart part = (MPart)element;
                partService.showPart(part, EPartService.PartState.CREATE);
            }
            if (element instanceof MElementContainer) {
                List children = ((MElementContainer)element).getChildren();
                for (Object child : children) {
                    if (!(child instanceof MUIElement)) continue;
                    OpenSnippetHandler.activateAll(partService).accept((MUIElement)child);
                }
            }
        };
    }

    public static Consumer<MUIElement> onClose(final IEventBroker eventBroker, final Runnable runnable) {
        return new Consumer<MUIElement>(){

            @Override
            public void accept(final MUIElement element) {
                if (element instanceof MPart) {
                    EventHandler handler = new EventHandler(){

                        public void handleEvent(Event event) {
                            Boolean val;
                            Object part = event.getProperty("ChangedElement");
                            if (part instanceof MPart && part == element && (val = (Boolean)event.getProperty("NewValue")) != null && !val.booleanValue()) {
                                eventBroker.unsubscribe((EventHandler)this);
                                runnable.run();
                            }
                        }
                    };
                    eventBroker.subscribe("org/eclipse/e4/ui/model/ui/UIElement/toBeRendered/*", handler);
                }
            }
        };
    }

    public static Consumer<MUIElement> focusPart(final EPartService partService) {
        return element -> {
            if (element instanceof MPart) {
                final MPart part = (MPart)element;
                if (partService != null) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            partService.activate(part, true);
                        }
                    });
                }
            }
        };
    }

    public static Consumer<MUIElement> openPart(EPartService partService) {
        return element -> {
            if (element instanceof MPart) {
                MPart part = (MPart)element;
                if (partService != null) {
                    part.setCloseable(true);
                    partService.showPart(part, EPartService.PartState.ACTIVATE);
                }
            }
        };
    }
}

