/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.filter.core.chromatogram;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.chemclipse.chromatogram.filter.core.chromatogram.ChromatogramFilter;
import org.eclipse.chemclipse.chromatogram.filter.core.chromatogram.IChromatogramFilterSupplier;
import org.eclipse.chemclipse.chromatogram.filter.core.chromatogram.IChromatogramFilterSupport;
import org.eclipse.chemclipse.chromatogram.filter.exceptions.NoChromatogramFilterSupplierAvailableException;
import org.eclipse.chemclipse.chromatogram.filter.settings.IChromatogramFilterSettings;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.model.supplier.ChromatogramSelectionProcessorSupplier;
import org.eclipse.chemclipse.model.types.DataType;
import org.eclipse.chemclipse.processing.core.MessageConsumer;
import org.eclipse.chemclipse.processing.core.MessageProvider;
import org.eclipse.chemclipse.processing.supplier.IProcessSupplier;
import org.eclipse.chemclipse.processing.supplier.IProcessTypeSupplier;
import org.eclipse.core.runtime.IProgressMonitor;
import org.osgi.service.component.annotations.Component;

@Component(service={IProcessTypeSupplier.class})
public class ChromatogramFilterProcessSupplier
implements IProcessTypeSupplier {
    public String getCategory() {
        return "Chromatogram Filter";
    }

    public Collection<IProcessSupplier<?>> getProcessorSuppliers() {
        try {
            IChromatogramFilterSupport support = ChromatogramFilter.getChromatogramFilterSupport();
            ArrayList list = new ArrayList();
            for (String processorId : support.getAvailableFilterIds()) {
                IChromatogramFilterSupplier supplier = support.getFilterSupplier(processorId);
                list.add((IProcessSupplier<?>)new ChromatogramFilterProcessorSupplier(supplier, this));
            }
            return list;
        }
        catch (NoChromatogramFilterSupplierAvailableException e) {
            return Collections.emptyList();
        }
    }

    private static final class ChromatogramFilterProcessorSupplier
    extends ChromatogramSelectionProcessorSupplier<IChromatogramFilterSettings> {
        private IChromatogramFilterSupplier supplier;

        public ChromatogramFilterProcessorSupplier(IChromatogramFilterSupplier supplier, IProcessTypeSupplier parent) {
            super("ChromatogramFilter." + supplier.getId(), supplier.getFilterName(), supplier.getDescription(), supplier.getSettingsClass(), parent, new DataType[]{DataType.MSD, DataType.CSD, DataType.WSD});
            this.supplier = supplier;
        }

        public IChromatogramSelection<?, ?> apply(IChromatogramSelection<?, ?> chromatogramSelection, IChromatogramFilterSettings processSettings, MessageConsumer messageConsumer, IProgressMonitor monitor) {
            if (processSettings instanceof IChromatogramFilterSettings) {
                messageConsumer.addMessages((MessageProvider)ChromatogramFilter.applyFilter(chromatogramSelection, processSettings, this.supplier.getId(), monitor));
            } else {
                messageConsumer.addMessages((MessageProvider)ChromatogramFilter.applyFilter(chromatogramSelection, this.supplier.getId(), monitor));
            }
            return chromatogramSelection;
        }

        public boolean matchesId(String id) {
            return super.matchesId(id) || this.supplier.getId().equals(id);
        }
    }
}

