/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.calculator.core.chromatogram;

import org.eclipse.chemclipse.chromatogram.xxd.calculator.core.chromatogram.IChromatogramCalculator;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.settings.IChromatogramCalculatorSettings;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.core.ProcessingInfo;

public abstract class AbstractChromatogramCalculator
implements IChromatogramCalculator {
    private static final String DESCRIPTION = "Chromatogram Calculator";

    @Override
    public IProcessingInfo validate(IChromatogramSelection chromatogramSelection, IChromatogramCalculatorSettings chromatogramCalculatorSettings) {
        ProcessingInfo processingInfo = new ProcessingInfo();
        processingInfo.addMessages(this.validateChromatogramSelection(chromatogramSelection));
        processingInfo.addMessages(this.validateCalculatorSettings(chromatogramCalculatorSettings));
        return processingInfo;
    }

    private IProcessingInfo validateChromatogramSelection(IChromatogramSelection chromatogramSelection) {
        ProcessingInfo processingInfo = new ProcessingInfo();
        if (chromatogramSelection == null) {
            processingInfo.addErrorMessage(DESCRIPTION, "The chromatogram selection is not valid.");
        } else if (chromatogramSelection.getChromatogram() == null) {
            processingInfo.addErrorMessage(DESCRIPTION, "The chromatogram is not valid.");
        }
        return processingInfo;
    }

    private IProcessingInfo validateCalculatorSettings(IChromatogramCalculatorSettings chromatogramFilterSettings) {
        ProcessingInfo processingInfo = new ProcessingInfo();
        if (chromatogramFilterSettings == null) {
            processingInfo.addErrorMessage(DESCRIPTION, "The calculator settings are not valid.");
        }
        return processingInfo;
    }
}

