/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.filter.supplier.rtshifter.preferences;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.chemclipse.chromatogram.xxd.filter.supplier.rtshifter.Activator;
import org.eclipse.chemclipse.chromatogram.xxd.filter.supplier.rtshifter.settings.FilterSettingsShift;
import org.eclipse.chemclipse.chromatogram.xxd.filter.supplier.rtshifter.settings.FilterSettingsStretch;
import org.eclipse.chemclipse.chromatogram.xxd.filter.supplier.rtshifter.settings.ShiftDirection;
import org.eclipse.chemclipse.support.preferences.IPreferenceSupplier;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;

public class PreferenceSupplier
implements IPreferenceSupplier {
    public static final String P_SHIFT_ALL_SCANS = "shiftAllScans";
    public static final boolean DEF_SHIFT_ALL_SCANS = true;
    public static final String P_MILLISECONDS_BACKWARD = "millisecondsBackward";
    public static final int DEF_MILLISECONDS_BACKWARD = 500;
    public static final String P_MILLISECONDS_FAST_BACKWARD = "millisecondsFastBackward";
    public static final int DEF_MILLISECONDS_FAST_BACKWARD = 1500;
    public static final String P_MILLISECONDS_FORWARD = "millisecondsForward";
    public static final int DEF_MILLISECONDS_FORWARD = 500;
    public static final String P_MILLISECONDS_FAST_FORWARD = "millisecondsFastForward";
    public static final int DEF_MILLISECONDS_FAST_FORWARD = 1500;
    public static final int SHIFT_MILLISECONDS_MIN = 0;
    public static final int SHIFT_MILLISECONDS_MAX = Integer.MAX_VALUE;
    public static final String P_DEFAULT_SHIFT_DIRECTION = "defaultShiftDirection";
    public static final String DEF_DEFAULT_SHIFT_DIRECTION = ShiftDirection.FORWARD.toString();
    public static final int MIN_X_OFFSET = -6000000;
    public static final int MIN_RETENTION_TIME = 0;
    public static final int MAX_RETENTION_TIME = 6000000;
    public static final String P_OVERLAY_X_OFFSET = "overlayXOffset";
    public static final int DEF_OVERLAY_X_OFFSET = 0;
    public static final String P_OVERLAY_Y_OFFSET = "overlayYOffset";
    public static final int DEF_OVERLAY_Y_OFFSET = 0;
    public static final String P_OFFSET_STEP_DOWN = "offsetStepUp";
    public static final int DEF_OFFSET_STEP_DOWN = 500000;
    public static final String P_OFFSET_STEP_UP = "offsetStepDown";
    public static final int DEF_OFFSET_STEP_UP = 500000;
    public static final String P_IS_LOCK_OFFSET = "isLockOffset";
    public static final boolean DEF_IS_LOCK_OFFSET = false;
    public static final String P_STRETCH_MILLISECONDS_SCAN_DELAY = "stretchMillisecondsScanDelay";
    public static final int DEF_STRETCH_MILLISECONDS_SCAN_DELAY = 0;
    public static final int STRETCH_MILLISECONDS_SCAN_DELAY_MIN = 0;
    public static final int STRETCH_MILLISECONDS_SCAN_DELAY_MAX = Integer.MAX_VALUE;
    public static final String P_STRETCH_MILLISECONDS_LENGTH = "stretchMillisecondsLength";
    public static final int DEF_STRETCH_MILLISECONDS_LENGTH = 6000000;
    public static final int STRETCH_MILLISECONDS_LENGTH_MIN = 0;
    public static final int STRETCH_MILLISECONDS_LENGTH_MAX = Integer.MAX_VALUE;
    private static IPreferenceSupplier preferenceSupplier;

    public static IPreferenceSupplier INSTANCE() {
        if (preferenceSupplier == null) {
            preferenceSupplier = new PreferenceSupplier();
        }
        return preferenceSupplier;
    }

    public IScopeContext getScopeContext() {
        return InstanceScope.INSTANCE;
    }

    public String getPreferenceNode() {
        return Activator.getContext().getBundle().getSymbolicName();
    }

    public Map<String, String> getDefaultValues() {
        HashMap<String, String> defaultValues = new HashMap<String, String>();
        defaultValues.put(P_SHIFT_ALL_SCANS, Boolean.toString(true));
        defaultValues.put(P_DEFAULT_SHIFT_DIRECTION, DEF_DEFAULT_SHIFT_DIRECTION);
        defaultValues.put(P_MILLISECONDS_BACKWARD, Integer.toString(500));
        defaultValues.put(P_MILLISECONDS_FAST_BACKWARD, Integer.toString(1500));
        defaultValues.put(P_MILLISECONDS_FORWARD, Integer.toString(500));
        defaultValues.put(P_MILLISECONDS_FAST_FORWARD, Integer.toString(1500));
        defaultValues.put(P_OVERLAY_X_OFFSET, Integer.toString(0));
        defaultValues.put(P_OVERLAY_Y_OFFSET, Integer.toString(0));
        defaultValues.put(P_OFFSET_STEP_DOWN, Integer.toString(500000));
        defaultValues.put(P_OFFSET_STEP_UP, Integer.toString(500000));
        defaultValues.put(P_IS_LOCK_OFFSET, Boolean.toString(false));
        defaultValues.put(P_STRETCH_MILLISECONDS_SCAN_DELAY, Integer.toString(0));
        defaultValues.put(P_STRETCH_MILLISECONDS_LENGTH, Integer.toString(6000000));
        return defaultValues;
    }

    public IEclipsePreferences getPreferences() {
        return this.getScopeContext().getNode(this.getPreferenceNode());
    }

    public static FilterSettingsShift getFilterSettingsShift() {
        IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
        ShiftDirection defaultShiftDirection = ShiftDirection.valueOf(preferences.get(P_DEFAULT_SHIFT_DIRECTION, DEF_DEFAULT_SHIFT_DIRECTION));
        boolean isShiftAllScans = PreferenceSupplier.getIsShiftAllScans();
        int millisecondsToShift = PreferenceSupplier.getMillisecondsToShift(preferences, defaultShiftDirection);
        FilterSettingsShift filterSettings = new FilterSettingsShift(millisecondsToShift, isShiftAllScans);
        return filterSettings;
    }

    public static FilterSettingsStretch getFilterSettingsStretch() {
        IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
        FilterSettingsStretch filterSettings = new FilterSettingsStretch(preferences.getInt(P_STRETCH_MILLISECONDS_LENGTH, 6000000));
        filterSettings.setScanDelay(preferences.getInt(P_STRETCH_MILLISECONDS_SCAN_DELAY, 0));
        return filterSettings;
    }

    public static boolean getIsShiftAllScans() {
        IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
        return preferences.getBoolean(P_SHIFT_ALL_SCANS, true);
    }

    private static int getMillisecondsToShift(IEclipsePreferences preferences, ShiftDirection defaultShiftDirection) {
        int millisecondsToShift;
        switch (defaultShiftDirection) {
            case BACKWARD: {
                millisecondsToShift = preferences.getInt(P_MILLISECONDS_BACKWARD, 500);
                if (millisecondsToShift <= 0) break;
                millisecondsToShift *= -1;
                break;
            }
            case FAST_BACKWARD: {
                millisecondsToShift = preferences.getInt(P_MILLISECONDS_FAST_BACKWARD, 1500);
                if (millisecondsToShift <= 0) break;
                millisecondsToShift *= -1;
                break;
            }
            case FORWARD: {
                millisecondsToShift = preferences.getInt(P_MILLISECONDS_FORWARD, 500);
                if (millisecondsToShift >= 0) break;
                millisecondsToShift *= -1;
                break;
            }
            case FAST_FORWARD: {
                millisecondsToShift = preferences.getInt(P_MILLISECONDS_FAST_FORWARD, 1500);
                if (millisecondsToShift >= 0) break;
                millisecondsToShift *= -1;
                break;
            }
            default: {
                millisecondsToShift = preferences.getInt(P_MILLISECONDS_FORWARD, 500);
            }
        }
        return millisecondsToShift;
    }

    public static int getMillisecondsToShiftBackward() {
        IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
        int millisecondsToShift = preferences.getInt(P_MILLISECONDS_BACKWARD, 500);
        if (millisecondsToShift > 0) {
            millisecondsToShift *= -1;
        }
        return millisecondsToShift;
    }

    public static int getMillisecondsToShiftFastBackward() {
        IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
        int millisecondsToShift = preferences.getInt(P_MILLISECONDS_FAST_BACKWARD, 1500);
        if (millisecondsToShift > 0) {
            millisecondsToShift *= -1;
        }
        return millisecondsToShift;
    }

    public static int getMillisecondsToShiftForward() {
        IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
        int millisecondsToShift = preferences.getInt(P_MILLISECONDS_FORWARD, 500);
        if (millisecondsToShift < 0) {
            millisecondsToShift *= -1;
        }
        return millisecondsToShift;
    }

    public static int getMillisecondsToShiftFastForward() {
        IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
        int millisecondsToShift = preferences.getInt(P_MILLISECONDS_FAST_FORWARD, 1500);
        if (millisecondsToShift < 0) {
            millisecondsToShift *= -1;
        }
        return millisecondsToShift;
    }

    public static int getOverlayXOffset() {
        IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
        return preferences.getInt(P_OVERLAY_X_OFFSET, 0);
    }

    public static int getOverlayYOffset() {
        IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
        return preferences.getInt(P_OVERLAY_Y_OFFSET, 0);
    }

    public static void resetOffset() {
        IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
        preferences.putInt(P_OVERLAY_X_OFFSET, 0);
        preferences.putInt(P_OVERLAY_Y_OFFSET, 0);
    }

    public static void decreaseXOffset() {
        IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
        int value = preferences.getInt(P_OVERLAY_X_OFFSET, 0) - preferences.getInt(P_MILLISECONDS_BACKWARD, 500);
        preferences.putInt(P_OVERLAY_X_OFFSET, value);
    }

    public static void decreaseXOffsetFast() {
        IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
        int value = preferences.getInt(P_OVERLAY_X_OFFSET, 0) - preferences.getInt(P_MILLISECONDS_FAST_BACKWARD, 1500);
        preferences.putInt(P_OVERLAY_X_OFFSET, value);
    }

    public static void increaseXOffset() {
        IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
        int value = preferences.getInt(P_OVERLAY_X_OFFSET, 0) + preferences.getInt(P_MILLISECONDS_FORWARD, 500);
        preferences.putInt(P_OVERLAY_X_OFFSET, value);
    }

    public static void increaseXOffsetFast() {
        IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
        int value = preferences.getInt(P_OVERLAY_X_OFFSET, 0) + preferences.getInt(P_MILLISECONDS_FAST_FORWARD, 1500);
        preferences.putInt(P_OVERLAY_X_OFFSET, value);
    }

    public static void decreaseYOffset() {
        IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
        int value = preferences.getInt(P_OVERLAY_Y_OFFSET, 0) - preferences.getInt(P_OFFSET_STEP_DOWN, 500000);
        preferences.putInt(P_OVERLAY_Y_OFFSET, value);
    }

    public static void increaseYOffset() {
        IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
        int value = preferences.getInt(P_OVERLAY_Y_OFFSET, 0) + preferences.getInt(P_OFFSET_STEP_UP, 500000);
        preferences.putInt(P_OVERLAY_Y_OFFSET, value);
    }

    public static boolean isLockOffset() {
        IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
        return preferences.getBoolean(P_IS_LOCK_OFFSET, false);
    }

    public static void toggleLockOffset() {
        IEclipsePreferences preferences;
        boolean value = (preferences = PreferenceSupplier.INSTANCE().getPreferences()).getBoolean(P_IS_LOCK_OFFSET, false);
        preferences.putBoolean(P_IS_LOCK_OFFSET, !value);
    }

    public static void setStretchScanDelay(int scanDelay) {
        IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
        preferences.putInt(P_STRETCH_MILLISECONDS_SCAN_DELAY, scanDelay);
    }

    public static void setStretchLength(int length) {
        IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
        preferences.putInt(P_STRETCH_MILLISECONDS_LENGTH, length);
    }
}

