/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.core.preprocessing;

import java.util.List;
import java.util.Random;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.core.preprocessing.AbstractDataModificator;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.core.preprocessing.IReplacer;
import org.eclipse.chemclipse.model.statistics.ISample;
import org.eclipse.chemclipse.model.statistics.ISampleData;
import org.eclipse.chemclipse.model.statistics.ISamples;
import org.eclipse.chemclipse.model.statistics.IVariable;

public class SmallValuesReplacer
extends AbstractDataModificator
implements IReplacer {
    @Override
    public String getDescription() {
        return "Replace NAN value with small random values";
    }

    @Override
    public String getName() {
        return "Small Random Value Setter";
    }

    @Override
    public <V extends IVariable, S extends ISample> void process(ISamples<V, S> samples) {
        List variables = samples.getVariables();
        List sampleList = samples.getSampleList();
        Random rand = new Random();
        int i = 0;
        while (i < variables.size()) {
            if (!this.skipVariable(samples, i)) {
                for (ISample sample : sampleList) {
                    ISampleData sampleData;
                    if (!sample.isSelected() && this.isOnlySelected() || !Double.isNaN(this.getData(sampleData = (ISampleData)sample.getSampleData().get(i)))) continue;
                    double replacement = -1.0;
                    while (replacement < 0.0) {
                        replacement = Double.longBitsToDouble(rand.nextLong());
                        if (replacement > 1.0E-20 && replacement > 0.0 && replacement < 1.0E-19) continue;
                        replacement = -1.0;
                    }
                    sampleData.setModifiedData(replacement);
                }
            }
            ++i;
        }
    }
}

