/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.core.preprocessing;

import java.util.List;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.core.preprocessing.AbstractDataModificator;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.core.preprocessing.IReplacer;
import org.eclipse.chemclipse.model.statistics.ISample;
import org.eclipse.chemclipse.model.statistics.ISampleData;
import org.eclipse.chemclipse.model.statistics.ISamples;
import org.eclipse.chemclipse.model.statistics.IVariable;

public class MeanValuesReplacer
extends AbstractDataModificator
implements IReplacer {
    @Override
    public String getDescription() {
        return "Replace NAN value with mean";
    }

    @Override
    public String getName() {
        return "Mean Value Setter";
    }

    @Override
    public <V extends IVariable, S extends ISample> void process(ISamples<V, S> samples) {
        List variables = samples.getVariables();
        List sampleList = samples.getSampleList();
        int i = 0;
        while (i < variables.size()) {
            if (!this.skipVariable(samples, i)) {
                double sum = 0.0;
                int count = 0;
                for (ISample sample : sampleList) {
                    double sampleData;
                    if (!sample.isSelected() && this.isOnlySelected() || Double.isNaN(sampleData = this.getData((ISampleData)sample.getSampleData().get(i)))) continue;
                    sum += sampleData;
                    ++count;
                }
                double mean = count != 0 ? sum / (double)count : 0.0;
                for (ISample sample : sampleList) {
                    ISampleData sampleData;
                    if (!sample.isSelected() && this.isOnlySelected() || !Double.isNaN(this.getData(sampleData = (ISampleData)sample.getSampleData().get(i)))) continue;
                    sampleData.setModifiedData(mean);
                }
            }
            ++i;
        }
    }
}

