/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.core.filters;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.core.filters.AbstractFilter;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.core.filters.IFilter;
import org.eclipse.chemclipse.model.statistics.IRetentionTime;
import org.eclipse.chemclipse.model.statistics.ISample;
import org.eclipse.chemclipse.model.statistics.ISamples;
import org.eclipse.chemclipse.model.statistics.IVariable;

public class RetentionTimeFilter
extends AbstractFilter
implements IFilter {
    public static final int DESELECT_INTERVAL = 1;
    public static final int SELECT_INTERVAL = 0;
    private int filtrationType = 0;
    private List<int[]> intervals = new ArrayList<int[]>();
    private String selectionResult = "";

    public RetentionTimeFilter() {
        super(IFilter.DataTypeProcessing.VARIABLES);
    }

    public List<int[]> copyInterval() {
        ArrayList<int[]> newIntervals = new ArrayList<int[]>();
        int i = 0;
        while (i < this.intervals.size()) {
            newIntervals.add(new int[]{this.intervals.get(i)[0], this.intervals.get(i)[1]});
            ++i;
        }
        return newIntervals;
    }

    @Override
    public <V extends IVariable, S extends ISample> List<Boolean> filter(ISamples<V, S> samples) {
        List variables = samples.getVariables();
        ArrayList<Boolean> selection = new ArrayList<Boolean>(variables.size());
        boolean set = this.filtrationType == 0;
        int i = 0;
        while (i < variables.size()) {
            selection.add(!set);
            ++i;
        }
        if (!IFilter.isRetentionTimes(variables)) {
            return selection;
        }
        for (int[] interval : this.intervals) {
            int begin = interval[0];
            int finish = interval[1];
            int i2 = 0;
            while (i2 < variables.size()) {
                int ret = ((IRetentionTime)variables.get(i2)).getRetentionTime();
                if (ret >= begin && ret <= finish) {
                    selection.set(i2, set);
                }
                ++i2;
            }
        }
        this.selectionResult = IFilter.getNumberSelectedRow(selection);
        return selection;
    }

    @Override
    public String getDescription() {
        StringBuilder sb = new StringBuilder();
        if (this.filtrationType == 0) {
            sb.append("Selected intervals: ");
        } else {
            sb.append("Deselected intevals: ");
        }
        int i = 0;
        while (i < this.intervals.size()) {
            sb.append("[");
            sb.append(Double.toString((double)this.intervals.get(i)[0] / 60000.0));
            sb.append(", ");
            sb.append(Double.toString((double)this.intervals.get(i)[1] / 60000.0));
            sb.append("] ");
            ++i;
        }
        return sb.toString();
    }

    public int getFiltrationType() {
        return this.filtrationType;
    }

    public List<int[]> getIntervals() {
        return this.intervals;
    }

    @Override
    public String getName() {
        return "Retention time intervals filter";
    }

    @Override
    public String getSelectionResult() {
        return this.selectionResult;
    }

    public void setFiltrationType(int filtrationType) {
        if (filtrationType >= 0 && filtrationType <= 1) {
            this.filtrationType = filtrationType;
        }
    }
}

