/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.core.filters;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.core.filters.AbstractFilter;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.core.filters.IFilter;
import org.eclipse.chemclipse.model.statistics.ISample;
import org.eclipse.chemclipse.model.statistics.ISamples;
import org.eclipse.chemclipse.model.statistics.IVariable;

public class RetentionTime2Filter
extends AbstractFilter
implements IFilter {
    private boolean inverse;
    private String selectionResult = "";
    private List<IVariable> variablesSelected;

    public RetentionTime2Filter(List<IVariable> variables, boolean inverse) {
        super(IFilter.DataTypeProcessing.VARIABLES);
        this.variablesSelected = new ArrayList<IVariable>(variables);
        this.inverse = inverse;
    }

    @Override
    public <V extends IVariable, S extends ISample> List<Boolean> filter(ISamples<V, S> samples) {
        int size = samples.getVariables().size();
        ArrayList<Boolean> seletions = new ArrayList<Boolean>(size);
        boolean selected = !this.inverse;
        int i = 0;
        while (i < size) {
            seletions.add(selected);
            ++i;
        }
        List variables = samples.getVariables();
        Set set = variables.stream().collect(Collectors.toSet());
        int i2 = 0;
        while (i2 < size) {
            IVariable variable = (IVariable)variables.get(i2);
            if (this.inverse) {
                seletions.set(i2, set.contains(variable));
            } else {
                seletions.set(i2, !set.contains(variable));
            }
            ++i2;
        }
        this.selectionResult = IFilter.getNumberSelectedRow(seletions);
        return seletions;
    }

    @Override
    public String getDescription() {
        if (this.inverse) {
            return "Select " + this.variablesSelected.size() + " retention times.";
        }
        return "Deselect " + this.variablesSelected.size() + " retention times.";
    }

    @Override
    public String getName() {
        return "Retention time filter";
    }

    @Override
    public String getSelectionResult() {
        return this.selectionResult;
    }

    public List<IVariable> getVariables() {
        return this.variablesSelected;
    }
}

