/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.peak.detector.supplier.amdis.runtime;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.eclipse.chemclipse.chromatogram.msd.peak.detector.supplier.amdis.internal.identifier.PathHelper;
import org.eclipse.chemclipse.chromatogram.msd.peak.detector.supplier.amdis.runtime.IAmdisSupport;
import org.eclipse.chemclipse.chromatogram.msd.peak.detector.supplier.amdis.settings.IOnsiteSettings;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.support.runtime.IRuntimeSupport;

public class AmdisSupport
implements IAmdisSupport {
    private static final Logger logger = Logger.getLogger(AmdisSupport.class);
    private IRuntimeSupport runtimeSupport;

    public AmdisSupport(IRuntimeSupport runtimeSupport) {
        this.runtimeSupport = runtimeSupport;
    }

    @Override
    public void modifySettings(IOnsiteSettings onsiteSettings) {
        try {
            int b;
            String line;
            File nistSettings = new File(this.getOnsiteIniFile());
            FileReader fileReader = new FileReader(nistSettings);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            File nistSettingsTmp = new File(PathHelper.getStoragePath() + File.separator + "ONSITE.INI");
            PrintWriter printWriter = new PrintWriter(nistSettingsTmp);
            while ((line = bufferedReader.readLine()) != null) {
                printWriter.println(onsiteSettings.getLine(line));
            }
            printWriter.flush();
            printWriter.close();
            bufferedReader.close();
            fileReader.close();
            FileReader in = new FileReader(nistSettingsTmp);
            FileWriter out = new FileWriter(nistSettings);
            while ((b = in.read()) != -1) {
                out.write(b);
            }
            in.close();
            out.flush();
            out.close();
        }
        catch (IOException e) {
            logger.warn((Object)e);
        }
    }

    @Override
    public boolean validateExecutable() {
        return this.runtimeSupport.getApplicationExecutable().toLowerCase().startsWith("amdis");
    }

    private String getOnsiteIniFile() {
        return String.valueOf(this.runtimeSupport.getApplicationPath()) + File.separator + "ONSITE.INI";
    }
}

