/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.peak.detector.supplier.firstderivative.settings;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.chemclipse.chromatogram.msd.peak.detector.settings.AbstractPeakDetectorSettingsMSD;
import org.eclipse.chemclipse.chromatogram.peak.detector.core.FilterMode;
import org.eclipse.chemclipse.chromatogram.peak.detector.model.Threshold;
import org.eclipse.chemclipse.msd.model.core.support.IMarkedIon;
import org.eclipse.chemclipse.msd.model.core.support.IMarkedIons;
import org.eclipse.chemclipse.msd.model.core.support.MarkedIon;
import org.eclipse.chemclipse.msd.model.core.support.MarkedIons;
import org.eclipse.chemclipse.numeric.statistics.WindowSize;
import org.eclipse.chemclipse.support.settings.EnumSelectionRadioButtonsSettingProperty;
import org.eclipse.chemclipse.support.settings.EnumSelectionSettingProperty;
import org.eclipse.chemclipse.support.settings.FloatSettingsProperty;

public class PeakDetectorSettingsMSD
extends AbstractPeakDetectorSettingsMSD {
    @JsonProperty(value="Threshold", defaultValue="MEDIUM")
    @EnumSelectionRadioButtonsSettingProperty
    private Threshold threshold = Threshold.MEDIUM;
    @JsonProperty(value="Include Background (VV: true, BV|VB: false)", defaultValue="false")
    private boolean includeBackground = false;
    @JsonProperty(value="Min S/N Ratio", defaultValue="0")
    @FloatSettingsProperty(minValue=0.0f, maxValue=3.4028235E38f)
    private float minimumSignalToNoiseRatio;
    @JsonProperty(value="Window Size", defaultValue="WIDTH_5")
    @JsonPropertyDescription(value="Window Size: 3, 5, 7, ..., 45")
    @EnumSelectionSettingProperty
    private WindowSize windowSize = WindowSize.WIDTH_5;
    @JsonProperty(value="Use Noise-Segments", defaultValue="false")
    @JsonPropertyDescription(value="Whether to use Nois-Segments to decide where peaks should be detected, this can improve the sensitivity of the algorithm")
    private boolean useNoiseSegments = false;
    @JsonProperty(value="Filter Mode", defaultValue="EXCLUDE")
    private FilterMode filterMode = FilterMode.EXCLUDE;
    @JsonProperty(value="m/z values to filter", defaultValue="")
    private String filterIonsString;
    @JsonProperty(value="Use Individual Traces", defaultValue="false")
    @JsonPropertyDescription(value="Uses each ion in the filter-list individualy to detect peaks")
    private boolean useIndividualTraces = false;
    @JsonProperty(value="Optimize Baseline (VV)", defaultValue="false")
    private boolean optimizeBaseline = false;

    @JsonIgnore
    public Collection<IMarkedIons> getFilterIons() {
        IMarkedIons.IonMarkMode ionMarkMode;
        switch (this.getFilterMode()) {
            case EXCLUDE: {
                ionMarkMode = IMarkedIons.IonMarkMode.INCLUDE;
                break;
            }
            case INCLUDE: {
                ionMarkMode = IMarkedIons.IonMarkMode.EXCLUDE;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported filter mode " + this.getFilterMode());
            }
        }
        Set ions = PeakDetectorSettingsMSD.parseIons(this.filterIonsString).stream().map(e -> new MarkedIon(e.doubleValue())).collect(Collectors.toSet());
        if (this.isUseIndividualTraces()) {
            ArrayList<IMarkedIons> list = new ArrayList<IMarkedIons>();
            for (MarkedIon ion : ions) {
                MarkedIons ionlist = new MarkedIons(ionMarkMode);
                ionlist.add((IMarkedIon)ion);
                list.add((IMarkedIons)ionlist);
            }
            return list;
        }
        MarkedIons ionlist = new MarkedIons(ionMarkMode);
        ionlist.addAll(ions);
        return Collections.singleton(ionlist);
    }

    public boolean isIncludeBackground() {
        return this.includeBackground;
    }

    public void setIncludeBackground(boolean includeBackground) {
        this.includeBackground = includeBackground;
    }

    public Threshold getThreshold() {
        return this.threshold;
    }

    public void setThreshold(Threshold threshold) {
        this.threshold = threshold;
    }

    public float getMinimumSignalToNoiseRatio() {
        return this.minimumSignalToNoiseRatio;
    }

    public void setMinimumSignalToNoiseRatio(float minimumSignalToNoiseRatio) {
        this.minimumSignalToNoiseRatio = minimumSignalToNoiseRatio;
    }

    public WindowSize getMovingAverageWindowSize() {
        return this.windowSize;
    }

    public void setMovingAverageWindowSize(WindowSize windowSize) {
        this.windowSize = windowSize;
    }

    public FilterMode getFilterMode() {
        return this.filterMode == null ? FilterMode.EXCLUDE : this.filterMode;
    }

    public void setFilterMode(FilterMode filterMode) {
        this.filterMode = filterMode;
    }

    public String getFilterIonsString() {
        return this.filterIonsString;
    }

    public void setFilterIonsString(String filterIonsString) {
        this.filterIonsString = filterIonsString;
    }

    static Collection<Number> parseIons(String filterIonsString) {
        String[] split;
        if (StringUtils.isBlank((CharSequence)filterIonsString)) {
            return Collections.emptyList();
        }
        ArrayList<Number> ionNumbers = new ArrayList<Number>();
        String[] stringArray = split = filterIonsString.trim().split("[\\s.,;]+");
        int n = split.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            try {
                ionNumbers.add(new BigDecimal(s));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            ++n2;
        }
        return ionNumbers;
    }

    public boolean isUseNoiseSegments() {
        return this.useNoiseSegments;
    }

    public void setUseNoiseSegments(boolean useNoiseSegments) {
        this.useNoiseSegments = useNoiseSegments;
    }

    public boolean isOptimizeBaseline() {
        return this.optimizeBaseline;
    }

    public void setOptimizeBaseline(boolean optimizeBaseline) {
        this.optimizeBaseline = optimizeBaseline;
    }

    public boolean isUseIndividualTraces() {
        return this.useIndividualTraces;
    }

    public void setUseIndividualTraces(boolean useIndividualTraces) {
        this.useIndividualTraces = useIndividualTraces;
    }
}

