/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.series;

import java.util.ArrayList;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.model.attribute.AxisType;
import org.eclipse.birt.chart.model.attribute.DataType;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.data.Query;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.SeriesGrouping;
import org.eclipse.birt.chart.model.impl.ChartModelHelper;
import org.eclipse.birt.chart.ui.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.DefaultSelectDataComponent;
import org.eclipse.birt.chart.ui.swt.DefaultSeriesUIProvider;
import org.eclipse.birt.chart.ui.swt.interfaces.IDataServiceProvider;
import org.eclipse.birt.chart.ui.swt.interfaces.ISelectDataComponent;
import org.eclipse.birt.chart.ui.swt.series.GanttDataDefinitionComponent;
import org.eclipse.birt.chart.ui.swt.series.GanttSeriesAttributeComposite;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizard;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.swt.wizard.data.YOptionalDataDefinitionComponent;
import org.eclipse.birt.chart.util.ChartExpressionUtil;
import org.eclipse.emf.common.util.EList;
import org.eclipse.swt.widgets.Composite;

public class GanttSeriesUIProvider
extends DefaultSeriesUIProvider {
    private static final String SERIES_CLASS = "org.eclipse.birt.chart.model.type.impl.GanttSeriesImpl";

    public Composite getSeriesAttributeSheet(Composite parent, Series series, ChartWizardContext context) {
        return new GanttSeriesAttributeComposite(parent, 0, context, series);
    }

    public String getSeriesClass() {
        return SERIES_CLASS;
    }

    public ISelectDataComponent getSeriesDataComponent(int seriesType, SeriesDefinition seriesDefn, ChartWizardContext context, String sTitle) {
        if (seriesType == 1) {
            return new GanttDataDefinitionComponent(seriesDefn, context, sTitle);
        }
        if (seriesType == 2) {
            YOptionalDataDefinitionComponent ddc = new YOptionalDataDefinitionComponent(1, "optional", seriesDefn, seriesDefn.getQuery(), context, sTitle);
            return ddc;
        }
        return new DefaultSelectDataComponent();
    }

    public AxisType[] getCompatibleAxisType(Series series) {
        return new AxisType[]{AxisType.DATE_TIME_LITERAL};
    }

    public void validateSeriesBindingType(Series series, IDataServiceProvider idsp) throws ChartException {
        ArrayList al = new ArrayList();
        al.addAll(series.getDataDefinition());
        int i = 0;
        while (i < al.size()) {
            Query query = (Query)al.get(i);
            DataType dataType = idsp.getDataType(query.getDefinition());
            if (i != 2 && (dataType == DataType.TEXT_LITERAL || dataType == DataType.NUMERIC_LITERAL)) {
                ChartExpressionUtil.ExpressionCodec codec = ChartModelHelper.instance().createExpressionCodec();
                codec.decode(query.getDefinition());
                throw new ChartException("org.eclipse.birt.chart.ui.extension", 19, codec.getExpression());
            }
            ++i;
        }
    }

    public boolean isValidAggregationType(Series series, SeriesDefinition orthSD, SeriesDefinition baseSD) {
        boolean isValidAgg = true;
        EList queries = series.getDataDefinition();
        int[] nArray = this.validationIndex(series);
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            if (!isValidAgg) break;
            Query query = (Query)queries.get(i);
            boolean checked = false;
            String id = "Gantt.aggCheck_" + series.eContainer().hashCode() + series.getDataDefinition().indexOf((Object)query);
            ChartWizard.removeException((String)id);
            if (query.getGrouping() != null && query.getGrouping().isEnabled()) {
                checked = true;
                isValidAgg = this.isValidAggregation(query.getGrouping(), false, id);
            }
            if (!checked && orthSD.getGrouping() != null && orthSD.getGrouping().isEnabled()) {
                checked = true;
                isValidAgg = this.isValidAggregation(orthSD.getGrouping(), false, id);
            }
            if (!checked && baseSD.getGrouping() != null && baseSD.getGrouping().isEnabled()) {
                isValidAgg = this.isValidAggregation(baseSD.getGrouping(), true, id);
            }
            ++n2;
        }
        return isValidAgg;
    }

    public int[] validationIndex(Series series) {
        int[] nArray = new int[2];
        nArray[1] = 1;
        return nArray;
    }

    private boolean isValidAggregation(SeriesGrouping grouping, boolean isCategoryGrouping, String id) {
        if (grouping == null || !grouping.isEnabled()) {
            return true;
        }
        String aggName = grouping.getAggregateExpression();
        if (!("First".equalsIgnoreCase(aggName) || "Last".equalsIgnoreCase(aggName) || "Min".equalsIgnoreCase(aggName) || "Max".equalsIgnoreCase(aggName))) {
            String aggPlace = "";
            aggPlace = isCategoryGrouping ? Messages.getString((String)"ChartUIUtil.TaskSelectData.Warning.CheckAgg.DefaultAggregate") : Messages.getString((String)"ChartUIUtil.TaskSelectData.Warning.CheckAgg.ValueSeriesAggregate");
            ChartWizard.showException((String)id, (String)(String.valueOf(Messages.getString((String)"ChartUIUtil.TaskSelectData.Warning.CheckAgg.GanttChart")) + aggName + Messages.getString((String)"ChartUIUtil.TaskSelectData.Warning.CheckAggAs") + aggPlace + Messages.getString((String)"ChartUIUtil.TaskSelectData.Warning.CheckAgg.Aggregation")));
            return false;
        }
        return true;
    }
}

