/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.wsd.swt.ui.components;

import org.eclipse.chemclipse.swt.ui.components.AbstractLineSeriesUI;
import org.eclipse.chemclipse.swt.ui.series.IMultipleSeries;
import org.eclipse.chemclipse.swt.ui.support.ChartUtil;
import org.eclipse.chemclipse.swt.ui.support.IAxisTitles;
import org.eclipse.chemclipse.wsd.model.core.selection.IChromatogramSelectionWSD;
import org.eclipse.chemclipse.wsd.model.notifier.IChromatogramSelectionWSDUpdateNotifier;
import org.eclipse.chemclipse.wsd.swt.ui.components.ProfileSpectrumAxisTitles;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.widgets.Composite;
import org.swtchart.Range;

public abstract class AbstractProfileScanUI
extends AbstractLineSeriesUI
implements IChromatogramSelectionWSDUpdateNotifier {
    private IChromatogramSelectionWSD chromatogramSelection;

    public AbstractProfileScanUI(Composite parent, int style) {
        super(parent, style, (IAxisTitles)new ProfileSpectrumAxisTitles());
    }

    public void update(IChromatogramSelectionWSD chromatogramSelection, boolean forceReload) {
        this.chromatogramSelection = chromatogramSelection;
        if (!this.isMaster() || this.isMaster() && forceReload) {
            double maxSignal = this.chromatogramSelection.getSelectedScan().getTotalSignal();
            this.setMaxSignal(maxSignal);
            this.setSeries(forceReload);
        }
    }

    public IChromatogramSelectionWSD getChromatogramSelection() {
        return this.chromatogramSelection;
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
    }

    public void mouseUp(MouseEvent e) {
    }

    private void setSecondaryRanges() {
        Range range;
        double max;
        assert (this.chromatogramSelection != null) : "The chromatogramSelection instance must be not null.";
        IMultipleSeries multipleLineSeries = this.getMultipleSeries();
        double min = multipleLineSeries.getXMin();
        if (min < (max = multipleLineSeries.getXMax())) {
            range = new Range(min, max);
            this.getXAxisTop().setRange(range);
        }
        if ((min = ChartUtil.getRelativeAbundance((double)this.getMaxSignal(), (double)multipleLineSeries.getYMin())) < (max = ChartUtil.getRelativeAbundance((double)this.getMaxSignal(), (double)multipleLineSeries.getYMax()))) {
            range = new Range(min, max);
            this.getYAxisRight().setRange(range);
        }
    }

    private void setSeries(boolean forceReload) {
        assert (this.chromatogramSelection != null) : "The chromatogramSelection instance must be not null.";
        this.deleteAllCurrentSeries();
        this.setViewSeries();
        this.getAxisSet().adjustRange();
        this.setSecondaryRanges();
        this.redraw();
    }
}

