/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.filter.supplier.rtshifter.ui.views;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.chemclipse.chromatogram.xxd.filter.supplier.rtshifter.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.chromatogram.xxd.filter.supplier.rtshifter.ui.modifier.FilterModifierStretch;
import org.eclipse.chemclipse.chromatogram.xxd.filter.supplier.rtshifter.ui.preferences.PreferencePage;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.progress.core.InfoType;
import org.eclipse.chemclipse.progress.core.StatusLineLogger;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.swt.ui.components.chromatogram.MultipleChromatogramOffsetUI;
import org.eclipse.chemclipse.swt.ui.preferences.SWTPreferencePage;
import org.eclipse.chemclipse.swt.ui.support.AxisTitlesIntensityScale;
import org.eclipse.chemclipse.swt.ui.support.IAxisTitles;
import org.eclipse.chemclipse.ux.extension.xxd.ui.views.AbstractChromatogramOverlayView;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;

public class ChromatogramStretchView
extends AbstractChromatogramOverlayView {
    private static final Logger logger = Logger.getLogger(ChromatogramStretchView.class);
    private static final String TYPE_SHORTEST = "TYPE_SHORTEST";
    private static final String TYPE_SELECTED = "TYPE_SELECTED";
    private static final String TYPE_LONGEST = "TYPE_LONGEST";
    @Inject
    private Composite composite;
    private MultipleChromatogramOffsetUI chromatogramOverlayUI;
    private Button buttonShrinkChromatograms;
    private Button buttonAlignToSelectedChromatogram;
    private Button buttonStretchChromatograms;

    @Inject
    public ChromatogramStretchView(EPartService partService, MPart part, IEventBroker eventBroker) {
        super(part, partService, eventBroker);
    }

    @PostConstruct
    private void createControl() {
        this.composite.setLayout((Layout)new GridLayout(1, false));
        this.createButtonBar(this.composite);
        this.createOverlayChart(this.composite);
    }

    private void createButtonBar(Composite composite) {
        Composite compositeButtons = new Composite(composite, 0);
        GridData gridDataCompositeRight = new GridData(768);
        gridDataCompositeRight.horizontalAlignment = 0x1000008;
        compositeButtons.setLayoutData((Object)gridDataCompositeRight);
        compositeButtons.setLayout((Layout)new GridLayout(4, false));
        this.createButtonsRight(compositeButtons);
    }

    private void createButtonsRight(Composite composite) {
        this.createButtonSettings(composite);
        this.createButtonShrinkChromatograms(composite);
        this.createButtonAlignToSelectedChromatogram(composite);
        this.createButtonStretchChromatograms(composite);
    }

    private void createButtonSettings(Composite composite) {
        Button buttonSettings = new Button(composite, 8);
        buttonSettings.setText("");
        buttonSettings.setImage(ApplicationImageFactory.getInstance().getImage("configure.gif", "16x16"));
        buttonSettings.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SWTPreferencePage preferencePage = new SWTPreferencePage();
                preferencePage.setTitle("Display Settings");
                PreferencePage preferencePageOverlay = new PreferencePage();
                preferencePageOverlay.setTitle("RT Shifter/Offset settings");
                PreferenceManager preferenceManager = new PreferenceManager();
                preferenceManager.addToRoot((IPreferenceNode)new PreferenceNode("1", (IPreferencePage)preferencePage));
                preferenceManager.addToRoot((IPreferenceNode)new PreferenceNode("2", (IPreferencePage)preferencePageOverlay));
                PreferenceDialog preferenceDialog = new PreferenceDialog(Display.getCurrent().getActiveShell(), preferenceManager);
                preferenceDialog.create();
                preferenceDialog.setMessage("Overlay/Shifter Settings");
                if (preferenceDialog.open() == 0) {
                    ChromatogramStretchView.this.update(ChromatogramStretchView.this.getChromatogramSelection(), false);
                }
            }
        });
    }

    private void createButtonShrinkChromatograms(Composite composite) {
        this.buttonShrinkChromatograms = new Button(composite, 8);
        this.buttonShrinkChromatograms.setText("");
        this.buttonShrinkChromatograms.setToolTipText("Shrink chromatograms");
        this.buttonShrinkChromatograms.setImage(ApplicationImageFactory.getInstance().getImage("shrinkChromatograms.gif", "16x16"));
        this.buttonShrinkChromatograms.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MessageBox messageBox = new MessageBox(Display.getCurrent().getActiveShell(), 200);
                messageBox.setText("Shrink to shortest chromatogram");
                messageBox.setMessage("Would you like to shrink all chromatograms?");
                if (messageBox.open() == 64) {
                    ChromatogramStretchView.this.stretchChromatograms(ChromatogramStretchView.TYPE_SHORTEST);
                }
            }
        });
    }

    private void createButtonAlignToSelectedChromatogram(Composite composite) {
        this.buttonAlignToSelectedChromatogram = new Button(composite, 8);
        this.buttonAlignToSelectedChromatogram.setText("");
        this.buttonAlignToSelectedChromatogram.setToolTipText("Align to selected chromatogram");
        this.buttonAlignToSelectedChromatogram.setImage(ApplicationImageFactory.getInstance().getImage("alignChromatograms.gif", "16x16"));
        this.buttonAlignToSelectedChromatogram.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MessageBox messageBox = new MessageBox(Display.getCurrent().getActiveShell(), 200);
                messageBox.setText("Align to selected chromatogram");
                messageBox.setMessage("Would you like to align all chromatograms?");
                if (messageBox.open() == 64) {
                    ChromatogramStretchView.this.stretchChromatograms(ChromatogramStretchView.TYPE_SELECTED);
                }
            }
        });
    }

    private void createButtonStretchChromatograms(Composite composite) {
        this.buttonStretchChromatograms = new Button(composite, 8);
        this.buttonStretchChromatograms.setText("");
        this.buttonStretchChromatograms.setToolTipText("Stretch chromatograms");
        this.buttonStretchChromatograms.setImage(ApplicationImageFactory.getInstance().getImage("stretchChromatograms.gif", "16x16"));
        this.buttonStretchChromatograms.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MessageBox messageBox = new MessageBox(Display.getCurrent().getActiveShell(), 200);
                messageBox.setText("Stretch to longest chromatogram");
                messageBox.setMessage("Would you like to stretch all chromatograms?");
                if (messageBox.open() == 64) {
                    ChromatogramStretchView.this.stretchChromatograms(ChromatogramStretchView.TYPE_LONGEST);
                }
            }
        });
    }

    private void createOverlayChart(Composite composite) {
        this.chromatogramOverlayUI = new MultipleChromatogramOffsetUI(composite, 0, (IAxisTitles)new AxisTitlesIntensityScale());
        this.chromatogramOverlayUI.setLayoutData((Object)new GridData(1808));
    }

    @PreDestroy
    private void preDestroy() {
        this.unsubscribe();
    }

    @Focus
    public void setFocus() {
        this.chromatogramOverlayUI.setFocus();
        this.update(this.getChromatogramSelection(), false);
    }

    public void update(IChromatogramSelection chromatogramSelection, boolean forceReload) {
        if (this.doUpdate(chromatogramSelection)) {
            List chromatogramSelections = this.getChromatogramSelections(chromatogramSelection, false);
            this.chromatogramOverlayUI.updateSelection(chromatogramSelections, forceReload);
        }
    }

    private void stretchChromatograms(String type) {
        IChromatogram chromatogram = this.getChromatogram(type);
        if (chromatogram != null) {
            PreferenceSupplier.setStretchScanDelay((int)chromatogram.getScanDelay());
            PreferenceSupplier.setStretchLength((int)chromatogram.getStopRetentionTime());
            List chromatogramSelections = this.getChromatogramSelections(this.getChromatogramSelection(), false);
            for (IChromatogramSelection chromatogramSelection : chromatogramSelections) {
                if (chromatogramSelection.getChromatogram() == chromatogram) continue;
                this.runStretchChromatogram(chromatogramSelection);
            }
        }
    }

    private void runStretchChromatogram(IChromatogramSelection chromatogramSelection) {
        StatusLineLogger.setInfo((InfoType)InfoType.MESSAGE, (String)"Start RTStretcher Filter");
        Display display = Display.getCurrent();
        FilterModifierStretch runnable = new FilterModifierStretch(chromatogramSelection);
        ProgressMonitorDialog monitor = new ProgressMonitorDialog(display.getActiveShell());
        try {
            monitor.run(true, true, (IRunnableWithProgress)runnable);
        }
        catch (InvocationTargetException e) {
            logger.warn((Object)e);
        }
        catch (InterruptedException e) {
            logger.warn((Object)e);
        }
        StatusLineLogger.setInfo((InfoType)InfoType.MESSAGE, (String)"RTStretcher Filter finished");
    }

    private IChromatogram getChromatogram(String type) {
        IChromatogram chromatogram;
        switch (type) {
            case "TYPE_SHORTEST": {
                chromatogram = this.getShortestChromatogram();
                break;
            }
            case "TYPE_SELECTED": {
                IChromatogramSelection chromatogramSelection = this.getChromatogramSelection();
                chromatogram = chromatogramSelection.getChromatogram();
                break;
            }
            case "TYPE_LONGEST": {
                chromatogram = this.getLongestChromatogram();
                break;
            }
            default: {
                chromatogram = null;
            }
        }
        return chromatogram;
    }

    private IChromatogram getShortestChromatogram() {
        List chromatogramSelections = this.getChromatogramSelections(this.getChromatogramSelection(), false);
        IChromatogram chromatogram = null;
        int maxRetentionTime = Integer.MAX_VALUE;
        for (IChromatogramSelection chromatogramSelection : chromatogramSelections) {
            if (chromatogramSelection.getChromatogram().getStopRetentionTime() >= maxRetentionTime) continue;
            maxRetentionTime = chromatogramSelection.getChromatogram().getStopRetentionTime();
            chromatogram = chromatogramSelection.getChromatogram();
        }
        return chromatogram;
    }

    private IChromatogram getLongestChromatogram() {
        List chromatogramSelections = this.getChromatogramSelections(this.getChromatogramSelection(), false);
        IChromatogram chromatogram = null;
        int minRetentionTime = Integer.MIN_VALUE;
        for (IChromatogramSelection chromatogramSelection : chromatogramSelections) {
            if (chromatogramSelection.getChromatogram().getStopRetentionTime() <= minRetentionTime) continue;
            minRetentionTime = chromatogramSelection.getChromatogram().getStopRetentionTime();
            chromatogram = chromatogramSelection.getChromatogram();
        }
        return chromatogram;
    }
}

