/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.swt.ui.internal.support;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.chemclipse.converter.core.ISupplier;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.msd.converter.massspectrum.MassSpectrumConverter;
import org.eclipse.chemclipse.msd.converter.processing.massspectrum.IMassSpectrumExportConverterProcessingInfo;
import org.eclipse.chemclipse.msd.model.core.IMassSpectra;
import org.eclipse.chemclipse.processing.core.exceptions.TypeCastException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class MassSpectraExportRunnable
implements IRunnableWithProgress {
    private static final Logger logger = Logger.getLogger(MassSpectraExportRunnable.class);
    private File data;
    private File file;
    private IMassSpectra massSpectra;
    private ISupplier supplier;

    public MassSpectraExportRunnable(File file, IMassSpectra massSpectra, ISupplier supplier) {
        this.file = file;
        this.massSpectra = massSpectra;
        this.supplier = supplier;
    }

    public File getData() {
        return this.data;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            monitor.beginTask("Export Mass Spectra", -1);
            IMassSpectrumExportConverterProcessingInfo processingInfo = MassSpectrumConverter.convert((File)this.file, (IMassSpectra)this.massSpectra, (boolean)false, (String)this.supplier.getId(), (IProgressMonitor)new SubProgressMonitor(monitor, -1));
            try {
                this.data = processingInfo.getFile();
            }
            catch (TypeCastException e) {
                logger.warn((Object)e);
            }
        }
        finally {
            monitor.done();
        }
    }
}

