/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.swt.ui.internal.provider;

import java.util.Collections;
import java.util.List;
import org.eclipse.chemclipse.model.comparator.SortOrder;
import org.eclipse.chemclipse.model.comparator.TargetExtendedComparator;
import org.eclipse.chemclipse.model.identifier.ILibraryInformation;
import org.eclipse.chemclipse.msd.model.core.IRegularLibraryMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.core.identifier.massspectrum.IMassSpectrumTarget;
import org.eclipse.chemclipse.support.ui.swt.AbstractRecordTableComparator;
import org.eclipse.chemclipse.support.ui.swt.IRecordTableComparator;
import org.eclipse.jface.viewers.Viewer;

public class MassSpectrumListTableComparator
extends AbstractRecordTableComparator
implements IRecordTableComparator {
    private TargetExtendedComparator targetExtendedComparator = new TargetExtendedComparator(SortOrder.DESC);

    public int compare(Viewer viewer, Object e1, Object e2) {
        int sortOrder = 0;
        if (e1 instanceof IRegularLibraryMassSpectrum && e2 instanceof IRegularLibraryMassSpectrum) {
            IRegularLibraryMassSpectrum massSpectrum1 = (IRegularLibraryMassSpectrum)e1;
            IRegularLibraryMassSpectrum massSpectrum2 = (IRegularLibraryMassSpectrum)e2;
            sortOrder = this.getSortOrder((IScanMSD)massSpectrum1, (IScanMSD)massSpectrum2, massSpectrum1.getLibraryInformation(), massSpectrum2.getLibraryInformation());
        } else if (e1 instanceof IScanMSD && e2 instanceof IScanMSD) {
            IScanMSD massSpectrum1 = (IScanMSD)e1;
            IScanMSD massSpectrum2 = (IScanMSD)e2;
            ILibraryInformation libraryInformation1 = this.getLibraryInformation(massSpectrum1.getTargets());
            ILibraryInformation libraryInformation2 = this.getLibraryInformation(massSpectrum2.getTargets());
            if (massSpectrum1.getOptimizedMassSpectrum() != null) {
                massSpectrum1 = massSpectrum1.getOptimizedMassSpectrum();
            }
            if (massSpectrum2.getOptimizedMassSpectrum() != null) {
                massSpectrum2 = massSpectrum2.getOptimizedMassSpectrum();
            }
            sortOrder = this.getSortOrder(massSpectrum1, massSpectrum2, libraryInformation1, libraryInformation2);
        }
        if (this.getDirection() == 0) {
            sortOrder = -sortOrder;
        }
        return sortOrder;
    }

    private int getSortOrder(IScanMSD massSpectrum1, IScanMSD massSpectrum2, ILibraryInformation libraryInformation1, ILibraryInformation libraryInformation2) {
        int sortOrder = 0;
        switch (this.getPropertyIndex()) {
            case 0: {
                if (libraryInformation1 == null || libraryInformation2 == null) break;
                sortOrder = libraryInformation2.getName().compareTo(libraryInformation1.getName());
                break;
            }
            case 1: {
                sortOrder = Integer.compare(massSpectrum2.getRetentionTime(), massSpectrum1.getRetentionTime());
                break;
            }
            case 2: {
                sortOrder = Float.compare(massSpectrum2.getRetentionIndex(), massSpectrum1.getRetentionIndex());
                break;
            }
            case 3: {
                sortOrder = Double.compare(massSpectrum2.getBasePeak(), massSpectrum1.getBasePeak());
                break;
            }
            case 4: {
                sortOrder = Float.compare(massSpectrum2.getBasePeakAbundance(), massSpectrum1.getBasePeakAbundance());
                break;
            }
            case 5: {
                sortOrder = Integer.compare(massSpectrum2.getNumberOfIons(), massSpectrum1.getNumberOfIons());
                break;
            }
            case 6: {
                if (libraryInformation1 == null || libraryInformation2 == null) break;
                sortOrder = libraryInformation2.getCasNumber().compareTo(libraryInformation1.getCasNumber());
                break;
            }
            case 7: {
                if (libraryInformation1 == null || libraryInformation2 == null) break;
                sortOrder = Double.compare(libraryInformation2.getMolWeight(), libraryInformation1.getMolWeight());
                break;
            }
            case 8: {
                if (libraryInformation1 == null || libraryInformation2 == null) break;
                sortOrder = libraryInformation2.getFormula().compareTo(libraryInformation1.getFormula());
                break;
            }
            case 9: {
                if (libraryInformation1 == null || libraryInformation2 == null) break;
                sortOrder = libraryInformation2.getSmiles().compareTo(libraryInformation1.getSmiles());
                break;
            }
            case 10: {
                if (libraryInformation1 == null || libraryInformation2 == null) break;
                sortOrder = libraryInformation2.getInChI().compareTo(libraryInformation1.getInChI());
                break;
            }
            case 11: {
                if (libraryInformation1 == null || libraryInformation2 == null) break;
                sortOrder = libraryInformation2.getReferenceIdentifier().compareTo(libraryInformation1.getReferenceIdentifier());
                break;
            }
            case 12: {
                if (libraryInformation1 == null || libraryInformation2 == null) break;
                sortOrder = libraryInformation2.getComments().compareTo(libraryInformation1.getComments());
                break;
            }
            default: {
                sortOrder = 0;
            }
        }
        return sortOrder;
    }

    private ILibraryInformation getLibraryInformation(List<IMassSpectrumTarget> targets) {
        ILibraryInformation libraryInformation = null;
        Collections.sort(targets, this.targetExtendedComparator);
        if (targets.size() >= 1) {
            libraryInformation = targets.get(0).getLibraryInformation();
        }
        return libraryInformation;
    }
}

