/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.swt.ui.internal.provider;

import java.util.List;
import java.util.Set;
import org.eclipse.chemclipse.model.identifier.IIdentificationTarget;
import org.eclipse.chemclipse.model.identifier.ILibraryInformation;
import org.eclipse.chemclipse.msd.model.core.ILibraryMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.core.identifier.massspectrum.IMassSpectrumTarget;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class MassSpectrumListFilter
extends ViewerFilter {
    private String searchText;
    private boolean caseSensitive;

    public void setSearchText(String searchText, boolean caseSensitive) {
        this.searchText = ".*" + searchText + ".*";
        this.caseSensitive = caseSensitive;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (this.searchText == null || this.searchText.equals("")) {
            return true;
        }
        if (element instanceof ILibraryMassSpectrum) {
            ILibraryMassSpectrum libraryMassSpectrum = (ILibraryMassSpectrum)element;
            ILibraryInformation libraryInformation = libraryMassSpectrum.getLibraryInformation();
            if (this.matchLibraryInformation(libraryInformation)) {
                return true;
            }
        } else if (element instanceof IScanMSD) {
            IScanMSD massSpectrum = (IScanMSD)element;
            List massSpectrumTargets = massSpectrum.getTargets();
            for (IMassSpectrumTarget massSpectrumTarget : massSpectrumTargets) {
                IMassSpectrumTarget identificationEntry;
                ILibraryInformation libraryInformation;
                if (!(massSpectrumTarget instanceof IIdentificationTarget) || !this.matchLibraryInformation(libraryInformation = (identificationEntry = massSpectrumTarget).getLibraryInformation())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean matchLibraryInformation(ILibraryInformation libraryInformation) {
        String searchText = this.searchText;
        String name = libraryInformation.getName();
        String referenceIdentifier = libraryInformation.getReferenceIdentifier();
        String formula = libraryInformation.getFormula();
        String smiles = libraryInformation.getSmiles();
        String inchi = libraryInformation.getInChI();
        String casNumber = libraryInformation.getCasNumber();
        String comments = libraryInformation.getComments();
        if (!this.caseSensitive) {
            searchText = searchText.toLowerCase();
            name = name.toLowerCase();
            referenceIdentifier = referenceIdentifier.toLowerCase();
            formula = formula.toLowerCase();
            casNumber = casNumber.toLowerCase();
            smiles = smiles.toLowerCase();
            inchi = inchi.toLowerCase();
            comments = comments.toLowerCase();
        }
        if (name.matches(searchText)) {
            return true;
        }
        if (referenceIdentifier.matches(searchText)) {
            return true;
        }
        if (formula.matches(searchText)) {
            return true;
        }
        if (smiles.matches(searchText)) {
            return true;
        }
        if (inchi.matches(searchText)) {
            return true;
        }
        if (casNumber.matches(searchText)) {
            return true;
        }
        if (comments.matches(searchText)) {
            return true;
        }
        Set synonyms = libraryInformation.getSynonyms();
        for (String synonym : synonyms) {
            if (!this.caseSensitive) {
                synonym = synonym.toLowerCase();
            }
            if (!synonym.matches(searchText)) continue;
            return true;
        }
        return false;
    }
}

