/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.swt.ui.internal.components.massspectrum;

import org.eclipse.chemclipse.msd.swt.ui.exceptions.NoIonAvailableException;
import org.eclipse.chemclipse.msd.swt.ui.internal.components.massspectrum.BarSeriesIon;
import org.eclipse.chemclipse.msd.swt.ui.internal.components.massspectrum.BarSeriesIons;
import org.eclipse.chemclipse.msd.swt.ui.internal.components.massspectrum.IBarSeriesIon;
import org.eclipse.chemclipse.msd.swt.ui.internal.components.massspectrum.IBarSeriesIons;
import org.eclipse.swt.graphics.Point;
import org.swtchart.IBarSeries;

public class BarSeriesUtil {
    private BarSeriesUtil() {
    }

    public static IBarSeriesIons getBarSeriesIonList(IBarSeries barSeries, int widthPlotArea) {
        BarSeriesIons barSeriesIons = null;
        if (barSeries != null) {
            barSeriesIons = new BarSeriesIons();
            double[] xSeries = barSeries.getXSeries();
            double[] ySeries = barSeries.getYSeries();
            int size = barSeries.getBounds().length;
            int i = 0;
            while (i < size) {
                Point point = barSeries.getPixelCoordinates(i);
                if (point.x >= 0 && point.x <= widthPlotArea) {
                    BarSeriesIon barSeriesIon = new BarSeriesIon(xSeries[i], ySeries[i], i);
                    barSeriesIons.add(barSeriesIon);
                }
                ++i;
            }
        }
        return barSeriesIons;
    }

    public static double getSelectedIon(int x, IBarSeries barSeries, int widthPlotArea) throws NoIonAvailableException {
        if (barSeries == null) {
            throw new NoIonAvailableException("BarSeries instance is null.");
        }
        IBarSeriesIons barSeriesIons = BarSeriesUtil.getBarSeriesIonList(barSeries, widthPlotArea);
        double deviation = BarSeriesUtil.getCalculatedDeviation(barSeries, barSeriesIons);
        double xMin = (double)x - deviation;
        double xMax = (double)x + deviation;
        int index = 0;
        while (index < barSeriesIons.size()) {
            IBarSeriesIon barSeriesIon = barSeriesIons.getBarSeriesIon(index);
            Point point = barSeries.getPixelCoordinates(barSeriesIon.getIndex());
            if ((double)point.x >= xMin && (double)point.x <= xMax && barSeriesIon.getAbundance() > 0.0) {
                return barSeriesIon.getIon();
            }
            ++index;
        }
        throw new NoIonAvailableException("There is no suitable ion.");
    }

    private static double getCalculatedDeviation(IBarSeries barSeries, IBarSeriesIons barSeriesIons) {
        double deviation = Double.MAX_VALUE;
        int index = 0;
        while (index < barSeriesIons.size() - 1) {
            Point pointActual = BarSeriesUtil.getPoint(barSeries, barSeriesIons, index);
            if (pointActual.x >= 0) {
                Point pointNext = BarSeriesUtil.getPoint(barSeries, barSeriesIons, index + 1);
                double delta = (double)pointNext.x - (double)pointActual.x;
                if (delta > 0.0 && delta < deviation) {
                    deviation = delta;
                }
            }
            ++index;
        }
        return deviation / 2.0;
    }

    private static Point getPoint(IBarSeries barSeries, IBarSeriesIons barSeriesIons, int index) {
        IBarSeriesIon barSeriesIon = barSeriesIons.getBarSeriesIon(index);
        Point point = barSeries.getPixelCoordinates(barSeriesIon.getIndex());
        return point;
    }
}

