/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.swt.ui.internal.components.massspectrum;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.chemclipse.msd.swt.ui.internal.components.massspectrum.BarSeriesIonComparator;
import org.eclipse.chemclipse.msd.swt.ui.internal.components.massspectrum.IBarSeriesIon;
import org.eclipse.chemclipse.msd.swt.ui.internal.components.massspectrum.IBarSeriesIons;
import org.eclipse.chemclipse.numeric.miscellaneous.SortOrder;

public class BarSeriesIons
implements IBarSeriesIons {
    private List<IBarSeriesIon> barSeriesIons = new ArrayList<IBarSeriesIon>();
    private BarSeriesIonComparator barSeriesIonComparatorAscending = new BarSeriesIonComparator(SortOrder.ASCENDING);
    private BarSeriesIonComparator barSeriesIonComparatorDescending = new BarSeriesIonComparator(SortOrder.DESCENDING);

    @Override
    public void add(IBarSeriesIon barSeriesIon) {
        this.barSeriesIons.add(barSeriesIon);
    }

    @Override
    public void clear() {
        this.barSeriesIons.clear();
    }

    @Override
    public List<IBarSeriesIon> getIonsWithHighestAbundance(int amount, boolean mirrored) {
        if (mirrored) {
            return this.getBarSeriesIons(amount, this.barSeriesIonComparatorAscending, mirrored);
        }
        return this.getBarSeriesIons(amount, this.barSeriesIonComparatorDescending, mirrored);
    }

    @Override
    public List<IBarSeriesIon> getIonsByModulo(int amount, boolean mirrored) {
        ArrayList<IBarSeriesIon> barSeries = new ArrayList<IBarSeriesIon>();
        if (amount > 0) {
            Collections.sort(this.barSeriesIons, this.barSeriesIonComparatorDescending);
            int modulo = this.barSeriesIons.size() / amount;
            int index = 0;
            while (index < this.barSeriesIons.size()) {
                if (barSeries.size() <= amount) {
                    this.addIon(barSeries, index, mirrored);
                } else if (index % modulo == 0) {
                    this.addIon(barSeries, index, mirrored);
                }
                ++index;
            }
        }
        return barSeries;
    }

    @Override
    public IBarSeriesIon getBarSeriesIon(int index) {
        if (index >= 0 && index < this.size()) {
            return this.barSeriesIons.get(index);
        }
        return null;
    }

    @Override
    public int size() {
        return this.barSeriesIons.size();
    }

    private void addIon(List<IBarSeriesIon> barSeries, int index, boolean mirrored) {
        IBarSeriesIon barSeriesIon = this.barSeriesIons.get(index);
        double abundance = barSeriesIon.getAbundance();
        if (mirrored) {
            if (abundance < 0.0) {
                barSeries.add(barSeriesIon);
            }
        } else if (abundance > 0.0) {
            barSeries.add(barSeriesIon);
        }
    }

    private List<IBarSeriesIon> getBarSeriesIons(int amount, BarSeriesIonComparator barSeriesIonComparator, boolean mirrored) {
        Collections.sort(this.barSeriesIons, barSeriesIonComparator);
        ArrayList<IBarSeriesIon> barSeries = new ArrayList<IBarSeriesIon>();
        if (amount > this.barSeriesIons.size()) {
            amount = this.barSeriesIons.size();
        }
        int index = 0;
        while (index < amount) {
            this.addIon(barSeries, index, mirrored);
            ++index;
        }
        return barSeries;
    }
}

