/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.swt.ui.components.massspectrum;

import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.msd.model.notifier.IChromatogramSelectionMSDUpdateNotifier;
import org.eclipse.chemclipse.msd.swt.ui.components.massspectrum.AbstractExtendedMassSpectrumUI;
import org.eclipse.chemclipse.msd.swt.ui.components.massspectrum.MassValueDisplayPrecision;
import org.eclipse.chemclipse.swt.ui.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.swt.ui.series.ISeries;
import org.eclipse.chemclipse.swt.ui.support.Colors;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.swtchart.IBarSeries;
import org.swtchart.ISeries;

public class ScanMassSpectrumUI
extends AbstractExtendedMassSpectrumUI
implements IChromatogramSelectionMSDUpdateNotifier {
    public ScanMassSpectrumUI(Composite parent, int style, MassValueDisplayPrecision massSpectrumType) {
        super(parent, style, massSpectrumType);
    }

    public void setViewSeries() {
        if (this.massSpectrum != null) {
            ISeries series = this.getSeries(this.massSpectrum);
            this.multipleLineSeries.add(series);
            this.barSeriesPositive = (IBarSeries)this.getSeriesSet().createSeries(ISeries.SeriesType.BAR, series.getId());
            this.barSeriesPositive.setXSeries(series.getXSeries());
            this.barSeriesPositive.setYSeries(series.getYSeries());
            this.barSeriesPositive.setBarWidthStyle(IBarSeries.BarWidthStyle.FIXED);
            this.barSeriesPositive.setBarWidth(1);
            Color massSpectrumColor = PreferenceSupplier.getMassSpectrumColor();
            if (massSpectrumColor == null) {
                massSpectrumColor = Colors.RED;
            }
            this.barSeriesPositive.setBarColor(massSpectrumColor);
        }
    }

    public void update(IChromatogramSelectionMSD chromatogramSelection, boolean forceReload) {
        this.chromatogramSelection = chromatogramSelection;
        this.massSpectrum = chromatogramSelection.getSelectedScan();
        if (!this.master || this.master && forceReload) {
            this.setSeries(forceReload);
        }
    }
}

