/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.swt.ui.components.massspectrum;

import java.text.DecimalFormat;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.identifier.ILibraryInformation;
import org.eclipse.chemclipse.msd.model.core.IRegularLibraryMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.notifier.IMassSpectrumSelectionUpdateNotifier;
import org.eclipse.chemclipse.msd.swt.ui.components.massspectrum.MassValueDisplayPrecision;
import org.eclipse.chemclipse.msd.swt.ui.components.massspectrum.SimpleMirroredMassSpectrumUI;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.support.text.ValueFormat;
import org.eclipse.chemclipse.swt.ui.preferences.PreferenceSupplier;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class MirroredMassSpectrumUIWithLabel
extends Composite
implements IMassSpectrumSelectionUpdateNotifier {
    private static final Logger logger = Logger.getLogger(MirroredMassSpectrumUIWithLabel.class);
    private Button pinButton;
    private Label infoLabelPinned;
    private SimpleMirroredMassSpectrumUI mirroredMassSpectrumUI;
    private Label infoLabelMirrored;
    private IScanMSD pinnedMassSpectrum;
    private IScanMSD mirroredMassSpectrum;
    private DecimalFormat decimalFormat = ValueFormat.getDecimalFormatEnglish((String)"0.0####");
    private MassValueDisplayPrecision massValueDisplayPrecision;
    private boolean isPinned = false;

    public MirroredMassSpectrumUIWithLabel(Composite parent, int style, MassValueDisplayPrecision massValueDisplayPrecision) {
        super(parent, style);
        this.massValueDisplayPrecision = massValueDisplayPrecision;
        this.initialize(parent);
    }

    private void initialize(Composite parent) {
        this.setLayout((Layout)new FillLayout());
        Composite composite = new Composite((Composite)this, 4);
        GridLayout layout = new GridLayout();
        layout.makeColumnsEqualWidth = true;
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        Composite labelbar = new Composite(composite, 4);
        labelbar.setLayout((Layout)new GridLayout(2, false));
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        labelbar.setLayoutData((Object)gridData);
        this.pinButton = new Button(labelbar, 8);
        this.setPinButtonText();
        this.pinButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MirroredMassSpectrumUIWithLabel.this.isPinned = !MirroredMassSpectrumUIWithLabel.this.isPinned;
                MirroredMassSpectrumUIWithLabel.this.setPinButtonText();
            }
        });
        this.infoLabelPinned = new Label(labelbar, 0);
        this.infoLabelPinned.setText("");
        this.infoLabelPinned.setLayoutData((Object)new GridData(768));
        this.mirroredMassSpectrumUI = new SimpleMirroredMassSpectrumUI(composite, 2052, this.massValueDisplayPrecision);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.mirroredMassSpectrumUI.setLayoutData(gridData);
        this.infoLabelMirrored = new Label(composite, 0);
        this.infoLabelMirrored.setText("");
        this.infoLabelMirrored.setLayoutData((Object)new GridData(768));
    }

    public void update(IScanMSD massSpectrum, boolean forceReload) {
        if (massSpectrum != null) {
            if (!this.isPinned && this.pinnedMassSpectrum != massSpectrum) {
                this.pinnedMassSpectrum = massSpectrum;
            }
            this.mirroredMassSpectrum = massSpectrum;
            try {
                IScanMSD pinnedMassSpectrumCopy = this.pinnedMassSpectrum.makeDeepCopy().normalize(1000.0f);
                IScanMSD mirroredMassSpectrumCopy = this.mirroredMassSpectrum.makeDeepCopy().normalize(1000.0f);
                this.setMassSpectrumLabel(pinnedMassSpectrumCopy, mirroredMassSpectrumCopy);
                this.mirroredMassSpectrumUI.update(pinnedMassSpectrumCopy, mirroredMassSpectrumCopy, forceReload);
            }
            catch (CloneNotSupportedException e) {
                logger.warn((Object)e);
            }
        } else {
            this.mirroredMassSpectrumUI.update(null, null, true);
        }
    }

    private void setPinButtonText() {
        this.pinButton.setText("");
        if (this.isPinned) {
            this.pinButton.setImage(ApplicationImageFactory.getInstance().getImage("unpinMassSpectrum.gif", "16x16"));
        } else {
            this.pinButton.setImage(ApplicationImageFactory.getInstance().getImage("pinMassSpectrum.gif", "16x16"));
        }
    }

    private void setMassSpectrumLabel(IScanMSD pinnedMassSpectrum, IScanMSD mirroredMassSpectrum) {
        this.setMassSpectrumLabel(pinnedMassSpectrum, "PINNED MS = ", this.infoLabelPinned);
        this.setMassSpectrumLabel(mirroredMassSpectrum, "REFERENCE MS = ", this.infoLabelMirrored);
    }

    private void setMassSpectrumLabel(IScanMSD massSpectrum, String title, Label label) {
        StringBuilder builder = new StringBuilder();
        builder.append(title);
        if (massSpectrum instanceof IRegularLibraryMassSpectrum) {
            IRegularLibraryMassSpectrum libraryMassSpectrum = (IRegularLibraryMassSpectrum)massSpectrum;
            ILibraryInformation libraryInformation = libraryMassSpectrum.getLibraryInformation();
            builder.append("NAME: ");
            builder.append(libraryInformation.getName());
            builder.append(" | ");
            builder.append("CAS: ");
            builder.append(libraryInformation.getCasNumber());
            builder.append(" | ");
        }
        builder.append("RT: ");
        builder.append(this.decimalFormat.format((double)massSpectrum.getRetentionTime() / 60000.0));
        builder.append(" | ");
        builder.append("RI: ");
        if (PreferenceSupplier.showRetentionIndexWithoutDecimals()) {
            builder.append(Integer.toString((int)massSpectrum.getRetentionIndex()));
        } else {
            builder.append(this.decimalFormat.format(massSpectrum.getRetentionIndex()));
        }
        label.setText(builder.toString());
    }
}

