/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.swt.ui.components.chromatogram;

import org.eclipse.chemclipse.msd.swt.ui.components.chromatogram.AbstractViewMSDChromatogramUI;
import org.eclipse.chemclipse.msd.swt.ui.converter.SeriesConverterMSD;
import org.eclipse.chemclipse.swt.ui.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.swt.ui.series.IMultipleSeries;
import org.eclipse.chemclipse.swt.ui.series.ISeries;
import org.eclipse.chemclipse.swt.ui.support.Colors;
import org.eclipse.chemclipse.swt.ui.support.IColorScheme;
import org.eclipse.chemclipse.swt.ui.support.IOffset;
import org.eclipse.chemclipse.swt.ui.support.Offset;
import org.eclipse.chemclipse.swt.ui.support.Sign;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.swtchart.ILineSeries;
import org.swtchart.ISeries;

public class MultipleChromatogramOffsetSelectedIonsUI
extends AbstractViewMSDChromatogramUI {
    private IOffset offset;

    public MultipleChromatogramOffsetSelectedIonsUI(Composite parent, int style, IOffset offset) {
        super(parent, style);
    }

    public void setOffset(IOffset offset) {
        this.offset = offset != null ? offset : new Offset(0.0, 0.0);
    }

    public void setViewSeries() {
        boolean showChromatogramArea = PreferenceSupplier.showChromatogramArea();
        IMultipleSeries multipleSeries = SeriesConverterMSD.convertChromatogramsUseSelectedIons(this.getChromatogramSelections(), Sign.POSITIVE, this.offset);
        int size = multipleSeries.getMultipleSeries().size();
        String colorSchemeOverlay = PreferenceSupplier.getColorSchemeOverlay();
        IColorScheme colorScheme = Colors.getColorScheme((String)colorSchemeOverlay);
        int i = 0;
        while (i < size) {
            ISeries series = (ISeries)multipleSeries.getMultipleSeries().get(i);
            this.setAdditionalChromatogramSeries(series, colorScheme.getColor(), i, showChromatogramArea);
            colorScheme.incrementColor();
            ++i;
        }
    }

    private void setAdditionalChromatogramSeries(ISeries series, Color color, int i, boolean showChromatogramArea) {
        this.addSeries(series);
        ILineSeries lineSeries = (ILineSeries)this.getSeriesSet().createSeries(ISeries.SeriesType.LINE, series.getId());
        lineSeries.setXSeries(series.getXSeries());
        lineSeries.setYSeries(series.getYSeries());
        lineSeries.enableArea(showChromatogramArea);
        lineSeries.setSymbolType(ILineSeries.PlotSymbolType.NONE);
        lineSeries.setLineColor(color);
    }
}

