/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.model.xic;

import org.eclipse.chemclipse.msd.model.xic.IIonRange;

public class IonRange
implements IIonRange {
    private int startIon;
    private int stopIon;

    public IonRange(int startIon, int stopIon) {
        if (startIon > stopIon) {
            int tmp = startIon;
            startIon = stopIon;
            stopIon = tmp;
        }
        if (startIon < 1 || startIon > 65535) {
            startIon = 1;
        }
        if (stopIon > 65535 || stopIon < 1) {
            stopIon = 65535;
        }
        this.startIon = startIon;
        this.stopIon = stopIon;
    }

    @Override
    public int getStartIon() {
        return this.startIon;
    }

    @Override
    public int getStopIon() {
        return this.stopIon;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        IonRange otherRange = (IonRange)other;
        return this.getStartIon() == otherRange.getStartIon() && this.getStopIon() == otherRange.getStopIon();
    }

    public int hashCode() {
        return 7 * Integer.valueOf(this.getStartIon()).hashCode() + 11 * Integer.valueOf(this.getStopIon()).hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getName());
        builder.append("[");
        builder.append("startIon=" + this.getStartIon());
        builder.append(",");
        builder.append("stopIon=" + this.getStopIon());
        builder.append("]");
        return builder.toString();
    }
}

