/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.model.xic;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.exceptions.AbundanceLimitExceededException;
import org.eclipse.chemclipse.model.exceptions.ChromatogramIsNullException;
import org.eclipse.chemclipse.model.signals.ITotalScanSignal;
import org.eclipse.chemclipse.model.signals.ITotalScanSignals;
import org.eclipse.chemclipse.model.signals.TotalScanSignal;
import org.eclipse.chemclipse.model.signals.TotalScanSignals;
import org.eclipse.chemclipse.model.support.IScanRange;
import org.eclipse.chemclipse.model.support.ScanRange;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.core.support.IMarkedIons;
import org.eclipse.chemclipse.msd.model.core.support.MarkedIons;
import org.eclipse.chemclipse.msd.model.exceptions.IonLimitExceededException;
import org.eclipse.chemclipse.msd.model.exceptions.NoExtractedIonSignalStoredException;
import org.eclipse.chemclipse.msd.model.implementation.Ion;
import org.eclipse.chemclipse.msd.model.implementation.RegularMassSpectrum;
import org.eclipse.chemclipse.msd.model.xic.ExtractedIonSignal;
import org.eclipse.chemclipse.msd.model.xic.IExtractedIonSignal;
import org.eclipse.chemclipse.msd.model.xic.IExtractedIonSignals;

public class ExtractedIonSignals
implements IExtractedIonSignals {
    private static final Logger logger = Logger.getLogger(ExtractedIonSignals.class);
    private List<IExtractedIonSignal> signals;
    private int startIon = Integer.MAX_VALUE;
    private int stopIon = 0;
    private int startScan = 0;
    private int stopScan = 0;
    private IChromatogramMSD chromatogram = null;

    public ExtractedIonSignals(int numberOfScans) {
        if (numberOfScans <= 0) {
            numberOfScans = 0;
            this.startScan = 0;
            this.stopScan = 0;
        } else {
            this.startScan = 1;
            this.stopScan = numberOfScans;
        }
        this.signals = new ArrayList<IExtractedIonSignal>(numberOfScans);
    }

    public ExtractedIonSignals(int numberOfScans, IChromatogramMSD chromatogram) {
        this(numberOfScans);
        this.chromatogram = chromatogram;
    }

    public ExtractedIonSignals(int startScan, int stopScan) {
        int numberOfScans;
        startScan = startScan <= 0 ? 0 : startScan;
        stopScan = stopScan <= 0 ? 0 : stopScan;
        int start = Math.min(startScan, stopScan);
        int stop = Math.max(startScan, stopScan);
        if (start == 0 || stop == 0) {
            numberOfScans = 0;
            start = 0;
            stop = 0;
        } else {
            numberOfScans = stop - start + 1;
        }
        this.signals = new ArrayList<IExtractedIonSignal>(numberOfScans);
        this.startScan = start;
        this.stopScan = stop;
    }

    public ExtractedIonSignals(int startScan, int stopScan, IChromatogramMSD chromatogram) {
        this(startScan, stopScan);
        this.chromatogram = chromatogram;
    }

    @Override
    public IChromatogramMSD getChromatogram() {
        return this.chromatogram;
    }

    @Override
    public void add(IExtractedIonSignal extractedIonSignal) {
        this.signals.add(extractedIonSignal);
        this.setStartIon(extractedIonSignal.getStartIon());
        this.setStopIon(extractedIonSignal.getStopIon());
    }

    @Override
    public void add(int ion, float abundance, int retentionTime, boolean removePreviousAbundance) {
        try {
            int scan = this.findClosestScan(retentionTime);
            if (scan > 0) {
                IExtractedIonSignal extractedIonSignal = this.getExtractedIonSignal(scan);
                extractedIonSignal.setAbundance(ion, abundance, removePreviousAbundance);
            }
        }
        catch (ChromatogramIsNullException e) {
            logger.warn((Object)e);
        }
        catch (NoExtractedIonSignalStoredException e) {
            logger.warn((Object)e);
        }
    }

    @Override
    public IExtractedIonSignal getExtractedIonSignal(int scan) throws NoExtractedIonSignalStoredException {
        if (scan <= 0) {
            throw new NoExtractedIonSignalStoredException("The requested scan: " + scan + " is not available.");
        }
        if (scan < this.startScan || scan > this.stopScan) {
            throw new NoExtractedIonSignalStoredException("The requested scan: " + scan + " is not available.");
        }
        int correction = this.startScan - 1;
        scan -= correction;
        return this.signals.get(--scan);
    }

    @Override
    public List<IExtractedIonSignal> getExtractedIonSignals() {
        return this.signals;
    }

    @Override
    public IScanMSD getScan(int scan) {
        MarkedIons excludedIons = new MarkedIons();
        return this.getScan(scan, excludedIons);
    }

    @Override
    public IScanMSD getScan(int scan, IMarkedIons excludedIons) {
        IExtractedIonSignal extractedIonSignal;
        try {
            extractedIonSignal = this.getExtractedIonSignal(scan);
        }
        catch (NoExtractedIonSignalStoredException e) {
            logger.warn((Object)e);
            return null;
        }
        RegularMassSpectrum massSpectrum = new RegularMassSpectrum();
        int startIon = extractedIonSignal.getStartIon();
        int stopIon = extractedIonSignal.getStopIon();
        massSpectrum.setParentChromatogram(this.getChromatogram());
        Set<Integer> excludedIonsNominal = excludedIons.getIonsNominal();
        int ion = startIon;
        while (ion <= stopIon) {
            float abundance;
            if (!excludedIonsNominal.contains(ion) && (abundance = extractedIonSignal.getAbundance(ion)) > 0.0f) {
                try {
                    Ion defaultIon = new Ion(ion, abundance);
                    massSpectrum.addIon(defaultIon);
                }
                catch (AbundanceLimitExceededException e) {
                    logger.warn((Object)e);
                }
                catch (IonLimitExceededException e) {
                    logger.warn((Object)e);
                }
            }
            ++ion;
        }
        return massSpectrum;
    }

    @Override
    public int getStartIon() {
        return this.startIon;
    }

    @Override
    public int getStopIon() {
        return this.stopIon;
    }

    @Override
    public int size() {
        return this.signals.size();
    }

    @Override
    public int getStartScan() {
        return this.startScan;
    }

    @Override
    public int getStopScan() {
        return this.stopScan;
    }

    @Override
    public ITotalScanSignals getTotalIonSignals(int ion) {
        ScanRange scanRange = new ScanRange(this.getStartScan(), this.getStopScan());
        return this.getTotalIonSignals(ion, (IScanRange)scanRange);
    }

    @Override
    public ITotalScanSignals getTotalIonSignals() {
        ScanRange scanRange = new ScanRange(this.getStartScan(), this.getStopScan());
        return this.getTotalIonSignals(0, (IScanRange)scanRange);
    }

    @Override
    public ITotalScanSignals getTotalIonSignals(IScanRange scanRange) {
        return this.getTotalIonSignals(0, scanRange);
    }

    @Override
    public ITotalScanSignals getTotalIonSignals(int ion, IScanRange scanRange) {
        int stopScan;
        int startScan;
        if (scanRange != null) {
            startScan = scanRange.getStartScan();
            stopScan = scanRange.getStopScan();
        } else {
            startScan = 0;
            stopScan = 0;
        }
        TotalScanSignals totalIonSignals = new TotalScanSignals(startScan, stopScan, (IChromatogram)this.getChromatogram());
        int scan = startScan;
        while (scan <= stopScan) {
            try {
                IExtractedIonSignal extractedIonSignal = this.getExtractedIonSignal(scan);
                int retentionTime = extractedIonSignal.getRetentionTime();
                float retentionIndex = extractedIonSignal.getRetentionIndex();
                float signal = ion == 0 ? extractedIonSignal.getTotalSignal() : extractedIonSignal.getAbundance(ion);
                TotalScanSignal totalIonSignal = new TotalScanSignal(retentionTime, retentionIndex, signal);
                totalIonSignals.add((ITotalScanSignal)totalIonSignal);
            }
            catch (NoExtractedIonSignalStoredException e) {
                logger.warn((Object)e);
            }
            ++scan;
        }
        return totalIonSignals;
    }

    @Override
    public IExtractedIonSignals makeDeepCopyWithoutSignals() {
        ExtractedIonSignals extractedIonSignals = new ExtractedIonSignals(this.startScan, this.stopScan, this.chromatogram);
        for (IExtractedIonSignal signal : this.signals) {
            ExtractedIonSignal extractedIonSignal = new ExtractedIonSignal(signal.getStartIon(), signal.getStopIon());
            extractedIonSignal.setRetentionTime(signal.getRetentionTime());
            extractedIonSignal.setRetentionIndex(signal.getRetentionIndex());
            extractedIonSignals.add(extractedIonSignal);
        }
        return extractedIonSignals;
    }

    private void setStartIon(int ion) {
        if (ion < this.startIon) {
            this.startIon = ion;
        }
    }

    private void setStopIon(int ion) {
        if (ion > this.stopIon) {
            this.stopIon = ion;
        }
    }

    private int findClosestScan(int retentionTime) throws ChromatogramIsNullException {
        if (this.chromatogram == null) {
            throw new ChromatogramIsNullException();
        }
        return this.chromatogram.getScanNumber(retentionTime);
    }
}

