/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.model.implementation;

import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.exceptions.AbundanceLimitExceededException;
import org.eclipse.chemclipse.msd.model.core.AbstractRegularMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.IIon;
import org.eclipse.chemclipse.msd.model.core.IRegularMassSpectrum;
import org.eclipse.chemclipse.msd.model.exceptions.IonLimitExceededException;
import org.eclipse.chemclipse.msd.model.implementation.Ion;

public class RegularMassSpectrum
extends AbstractRegularMassSpectrum
implements IRegularMassSpectrum {
    private static final long serialVersionUID = -1093372356722684379L;
    private static final Logger logger = Logger.getLogger(RegularMassSpectrum.class);

    @Override
    public IRegularMassSpectrum makeDeepCopy() throws CloneNotSupportedException {
        IRegularMassSpectrum massSpectrum = (IRegularMassSpectrum)super.clone();
        for (IIon ion : this.getIons()) {
            try {
                Ion defaultIon = new Ion(ion.getIon(), ion.getAbundance());
                massSpectrum.addIon(defaultIon);
            }
            catch (AbundanceLimitExceededException e) {
                logger.warn((Object)e);
            }
            catch (IonLimitExceededException e) {
                logger.warn((Object)e);
            }
        }
        return massSpectrum;
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        return this.makeDeepCopy();
    }
}

