/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.model.core.support;

import java.util.List;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.core.IPeakIntensityValues;
import org.eclipse.chemclipse.model.exceptions.ChromatogramIsNullException;
import org.eclipse.chemclipse.model.exceptions.PeakException;
import org.eclipse.chemclipse.model.implementation.PeakIntensityValues;
import org.eclipse.chemclipse.model.signals.ITotalScanSignal;
import org.eclipse.chemclipse.model.signals.ITotalScanSignals;
import org.eclipse.chemclipse.model.signals.TotalScanSignalExtractor;
import org.eclipse.chemclipse.model.signals.TotalScanSignalsModifier;
import org.eclipse.chemclipse.model.support.BackgroundAbundanceRange;
import org.eclipse.chemclipse.model.support.IBackgroundAbundanceRange;
import org.eclipse.chemclipse.model.support.IScanRange;
import org.eclipse.chemclipse.model.support.ScanRange;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.msd.model.core.IChromatogramPeakMSD;
import org.eclipse.chemclipse.msd.model.core.IPeakMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.IPeakModelMSD;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.core.support.IMarkedIons;
import org.eclipse.chemclipse.msd.model.implementation.ChromatogramPeakMSD;
import org.eclipse.chemclipse.msd.model.implementation.PeakMassSpectrum;
import org.eclipse.chemclipse.msd.model.implementation.PeakModelMSD;
import org.eclipse.chemclipse.msd.model.xic.IExtractedIonSignals;
import org.eclipse.chemclipse.msd.model.xic.TotalIonSignalExtractor;
import org.eclipse.chemclipse.numeric.core.IPoint;
import org.eclipse.chemclipse.numeric.core.Point;
import org.eclipse.chemclipse.numeric.equations.Equations;
import org.eclipse.chemclipse.numeric.equations.LinearEquation;

public class PeakBuilderMSD {
    public static IChromatogramPeakMSD createPeak(IChromatogramMSD chromatogram, IScanRange scanRange, boolean calculatePeakIncludedBackground) throws PeakException {
        BackgroundAbundanceRange backgroundAbundanceRange;
        PeakBuilderMSD.validateChromatogram(chromatogram);
        PeakBuilderMSD.validateScanRange(scanRange);
        PeakBuilderMSD.checkScanRange(chromatogram, scanRange);
        ITotalScanSignals totalIonSignals = PeakBuilderMSD.getTotalIonSignals(chromatogram, scanRange);
        ITotalScanSignal totalIonSignal = totalIonSignals.getTotalScanSignal(scanRange.getStartScan());
        float startBackgroundAbundance = totalIonSignal.getTotalSignal();
        totalIonSignal = totalIonSignals.getTotalScanSignal(scanRange.getStopScan());
        float stopBackgroundAbundance = totalIonSignal.getTotalSignal();
        if (calculatePeakIncludedBackground) {
            backgroundAbundanceRange = new BackgroundAbundanceRange(startBackgroundAbundance, stopBackgroundAbundance);
        } else {
            float base = Math.min(startBackgroundAbundance, stopBackgroundAbundance);
            backgroundAbundanceRange = new BackgroundAbundanceRange(base, base);
        }
        LinearEquation backgroundEquation = PeakBuilderMSD.getBackgroundEquation(totalIonSignals, scanRange, (IBackgroundAbundanceRange)backgroundAbundanceRange);
        ITotalScanSignals peakIntensityTotalIonSignals = PeakBuilderMSD.adjustTotalIonSignals(totalIonSignals, backgroundEquation);
        IPeakIntensityValues peakIntensityValues = PeakBuilderMSD.getPeakIntensityValues(peakIntensityTotalIonSignals);
        IPeakMassSpectrum peakMassSpectrum = PeakBuilderMSD.getPeakMassSpectrum(chromatogram, totalIonSignals, backgroundEquation, null);
        PeakModelMSD peakModel = new PeakModelMSD(peakMassSpectrum, peakIntensityValues, backgroundAbundanceRange.getStartBackgroundAbundance(), backgroundAbundanceRange.getStopBackgroundAbundance());
        ChromatogramPeakMSD peak = new ChromatogramPeakMSD((IPeakModelMSD)peakModel, chromatogram);
        return peak;
    }

    public static IChromatogramPeakMSD createPeak(IChromatogramMSD chromatogram, IScanRange scanRange, IBackgroundAbundanceRange backgroundAbundanceRange, boolean checkBackgroundAbundanceRange) throws PeakException {
        PeakBuilderMSD.validateChromatogram(chromatogram);
        PeakBuilderMSD.validateScanRange(scanRange);
        PeakBuilderMSD.validateBackgroundAbundanceRange(backgroundAbundanceRange);
        ITotalScanSignals totalIonSignals = PeakBuilderMSD.getTotalIonSignals(chromatogram, scanRange);
        if (checkBackgroundAbundanceRange) {
            backgroundAbundanceRange = PeakBuilderMSD.checkBackgroundAbundanceRange(totalIonSignals, scanRange, backgroundAbundanceRange);
        }
        LinearEquation backgroundEquation = PeakBuilderMSD.getBackgroundEquation(totalIonSignals, scanRange, backgroundAbundanceRange);
        ITotalScanSignals peakIntensityTotalIonSignals = PeakBuilderMSD.adjustTotalIonSignals(totalIonSignals, backgroundEquation);
        IPeakIntensityValues peakIntensityValues = PeakBuilderMSD.getPeakIntensityValues(peakIntensityTotalIonSignals);
        IPeakMassSpectrum peakMassSpectrum = PeakBuilderMSD.getPeakMassSpectrum(chromatogram, totalIonSignals, backgroundEquation, null);
        PeakModelMSD peakModel = new PeakModelMSD(peakMassSpectrum, peakIntensityValues, backgroundAbundanceRange.getStartBackgroundAbundance(), backgroundAbundanceRange.getStopBackgroundAbundance());
        ChromatogramPeakMSD peak = new ChromatogramPeakMSD((IPeakModelMSD)peakModel, chromatogram);
        return peak;
    }

    public static IChromatogramPeakMSD createPeak(IChromatogramMSD chromatogram, IScanRange scanRange, IMarkedIons excludedIons) throws PeakException {
        PeakBuilderMSD.validateChromatogram(chromatogram);
        PeakBuilderMSD.validateScanRange(scanRange);
        PeakBuilderMSD.validateExcludedIons(excludedIons);
        ITotalScanSignals totalIonSignals = PeakBuilderMSD.getTotalIonSignals(chromatogram, scanRange, excludedIons);
        ITotalScanSignal totalIonSignal = totalIonSignals.getTotalScanSignal(scanRange.getStartScan());
        float startBackgroundAbundance = totalIonSignal.getTotalSignal();
        totalIonSignal = totalIonSignals.getTotalScanSignal(scanRange.getStopScan());
        float stopBackgroundAbundance = totalIonSignal.getTotalSignal();
        BackgroundAbundanceRange backgroundAbundanceRange = new BackgroundAbundanceRange(startBackgroundAbundance, stopBackgroundAbundance);
        LinearEquation backgroundEquation = PeakBuilderMSD.getBackgroundEquation(totalIonSignals, scanRange, (IBackgroundAbundanceRange)backgroundAbundanceRange);
        ITotalScanSignals peakIntensityTotalIonSignals = PeakBuilderMSD.adjustTotalIonSignals(totalIonSignals, backgroundEquation);
        IPeakIntensityValues peakIntensityValues = PeakBuilderMSD.getPeakIntensityValues(peakIntensityTotalIonSignals);
        IPeakMassSpectrum peakMassSpectrum = PeakBuilderMSD.getPeakMassSpectrum(chromatogram, totalIonSignals, backgroundEquation, excludedIons);
        PeakModelMSD peakModel = new PeakModelMSD(peakMassSpectrum, peakIntensityValues, backgroundAbundanceRange.getStartBackgroundAbundance(), backgroundAbundanceRange.getStopBackgroundAbundance());
        ChromatogramPeakMSD peak = new ChromatogramPeakMSD((IPeakModelMSD)peakModel, chromatogram);
        return peak;
    }

    public static IChromatogramPeakMSD createPeak(IChromatogramMSD chromatogram, IScanRange scanRange, IBackgroundAbundanceRange backgroundAbundanceRange, IMarkedIons excludedIons) throws PeakException {
        PeakBuilderMSD.validateChromatogram(chromatogram);
        PeakBuilderMSD.validateScanRange(scanRange);
        PeakBuilderMSD.validateExcludedIons(excludedIons);
        PeakBuilderMSD.validateBackgroundAbundanceRange(backgroundAbundanceRange);
        ITotalScanSignals totalIonSignals = PeakBuilderMSD.getTotalIonSignals(chromatogram, scanRange, excludedIons);
        backgroundAbundanceRange = PeakBuilderMSD.checkBackgroundAbundanceRange(totalIonSignals, scanRange, backgroundAbundanceRange);
        LinearEquation backgroundEquation = PeakBuilderMSD.getBackgroundEquation(totalIonSignals, scanRange, backgroundAbundanceRange);
        ITotalScanSignals peakIntensityTotalIonSignals = PeakBuilderMSD.adjustTotalIonSignals(totalIonSignals, backgroundEquation);
        IPeakIntensityValues peakIntensityValues = PeakBuilderMSD.getPeakIntensityValues(peakIntensityTotalIonSignals);
        IPeakMassSpectrum peakMassSpectrum = PeakBuilderMSD.getPeakMassSpectrum(chromatogram, totalIonSignals, backgroundEquation, excludedIons);
        PeakModelMSD peakModel = new PeakModelMSD(peakMassSpectrum, peakIntensityValues, backgroundAbundanceRange.getStartBackgroundAbundance(), backgroundAbundanceRange.getStopBackgroundAbundance());
        ChromatogramPeakMSD peak = new ChromatogramPeakMSD((IPeakModelMSD)peakModel, chromatogram);
        return peak;
    }

    public static IChromatogramPeakMSD createPeak(IChromatogramMSD chromatogram, ITotalScanSignals totalIonSignals, IPeakMassSpectrum peakMassSpectrum) throws PeakException {
        PeakBuilderMSD.validateChromatogram(chromatogram);
        PeakBuilderMSD.validateTotalIonSignals(totalIonSignals);
        PeakBuilderMSD.validatePeakMassSpectrum(peakMassSpectrum);
        ScanRange scanRange = new ScanRange(totalIonSignals.getStartScan(), totalIonSignals.getStopScan());
        ITotalScanSignal totalIonSignal = totalIonSignals.getTotalScanSignal(scanRange.getStartScan());
        float startBackgroundAbundance = totalIonSignal.getTotalSignal();
        totalIonSignal = totalIonSignals.getTotalScanSignal(scanRange.getStopScan());
        float stopBackgroundAbundance = totalIonSignal.getTotalSignal();
        BackgroundAbundanceRange backgroundAbundanceRange = new BackgroundAbundanceRange(startBackgroundAbundance, stopBackgroundAbundance);
        LinearEquation backgroundEquation = PeakBuilderMSD.getBackgroundEquation(totalIonSignals, (IScanRange)scanRange, (IBackgroundAbundanceRange)backgroundAbundanceRange);
        ITotalScanSignals peakIntensityTotalIonSignals = PeakBuilderMSD.adjustTotalIonSignals(totalIonSignals, backgroundEquation);
        IPeakIntensityValues peakIntensityValues = PeakBuilderMSD.getPeakIntensityValues(peakIntensityTotalIonSignals);
        PeakModelMSD peakModel = new PeakModelMSD(peakMassSpectrum, peakIntensityValues, backgroundAbundanceRange.getStartBackgroundAbundance(), backgroundAbundanceRange.getStopBackgroundAbundance());
        ChromatogramPeakMSD peak = new ChromatogramPeakMSD((IPeakModelMSD)peakModel, chromatogram);
        return peak;
    }

    public static IChromatogramPeakMSD createPeak(IChromatogramMSD chromatogram, ITotalScanSignals totalIonSignals, IPeakMassSpectrum peakMassSpectrum, IBackgroundAbundanceRange backgroundAbundanceRange) throws PeakException {
        PeakBuilderMSD.validateChromatogram(chromatogram);
        PeakBuilderMSD.validateTotalIonSignals(totalIonSignals);
        PeakBuilderMSD.validatePeakMassSpectrum(peakMassSpectrum);
        PeakBuilderMSD.validateBackgroundAbundanceRange(backgroundAbundanceRange);
        ScanRange scanRange = new ScanRange(totalIonSignals.getStartScan(), totalIonSignals.getStopScan());
        backgroundAbundanceRange = PeakBuilderMSD.checkBackgroundAbundanceRange(totalIonSignals, (IScanRange)scanRange, backgroundAbundanceRange);
        LinearEquation backgroundEquation = PeakBuilderMSD.getBackgroundEquation(totalIonSignals, (IScanRange)scanRange, backgroundAbundanceRange);
        ITotalScanSignals peakIntensityTotalIonSignals = PeakBuilderMSD.adjustTotalIonSignals(totalIonSignals, backgroundEquation);
        IPeakIntensityValues peakIntensityValues = PeakBuilderMSD.getPeakIntensityValues(peakIntensityTotalIonSignals);
        PeakModelMSD peakModel = new PeakModelMSD(peakMassSpectrum, peakIntensityValues, backgroundAbundanceRange.getStartBackgroundAbundance(), backgroundAbundanceRange.getStopBackgroundAbundance());
        ChromatogramPeakMSD peak = new ChromatogramPeakMSD((IPeakModelMSD)peakModel, chromatogram);
        return peak;
    }

    public static IChromatogramPeakMSD createPeak(IExtractedIonSignals extractedIonSignals, IScanRange scanRange) throws PeakException {
        PeakBuilderMSD.validateExtractedIonSignals(extractedIonSignals);
        PeakBuilderMSD.validateScanRange(scanRange);
        PeakBuilderMSD.checkScanRange(extractedIonSignals, scanRange);
        IChromatogramMSD chromatogram = extractedIonSignals.getChromatogram();
        PeakBuilderMSD.validateChromatogram(chromatogram);
        ITotalScanSignals totalIonSignals = extractedIonSignals.getTotalIonSignals(scanRange);
        ITotalScanSignal totalIonSignal = totalIonSignals.getTotalScanSignal(scanRange.getStartScan());
        float startBackgroundAbundance = totalIonSignal.getTotalSignal();
        totalIonSignal = totalIonSignals.getTotalScanSignal(scanRange.getStopScan());
        float stopBackgroundAbundance = totalIonSignal.getTotalSignal();
        BackgroundAbundanceRange backgroundAbundanceRange = new BackgroundAbundanceRange(startBackgroundAbundance, stopBackgroundAbundance);
        LinearEquation backgroundEquation = PeakBuilderMSD.getBackgroundEquation(totalIonSignals, scanRange, (IBackgroundAbundanceRange)backgroundAbundanceRange);
        ITotalScanSignals peakIntensityTotalIonSignals = PeakBuilderMSD.adjustTotalIonSignals(totalIonSignals, backgroundEquation);
        IPeakIntensityValues peakIntensityValues = PeakBuilderMSD.getPeakIntensityValues(peakIntensityTotalIonSignals);
        IPeakMassSpectrum peakMassSpectrum = PeakBuilderMSD.getPeakMassSpectrum(extractedIonSignals, chromatogram, totalIonSignals, backgroundEquation, null);
        PeakModelMSD peakModel = new PeakModelMSD(peakMassSpectrum, peakIntensityValues, backgroundAbundanceRange.getStartBackgroundAbundance(), backgroundAbundanceRange.getStopBackgroundAbundance());
        ChromatogramPeakMSD peak = new ChromatogramPeakMSD((IPeakModelMSD)peakModel, chromatogram);
        return peak;
    }

    protected static IPeakMassSpectrum getPeakMassSpectrum(IExtractedIonSignals extractedIonSignals, IChromatogramMSD chromatogram, ITotalScanSignals totalIonSignals, LinearEquation backgroundEquation, IMarkedIons excludedIons) throws PeakException {
        assert (extractedIonSignals != null) : "The extracted ion signals instance must not be null.";
        assert (chromatogram != null) : "The chromatogram must not be null.";
        assert (totalIonSignals != null) : "The total ion signals must not be null.";
        assert (backgroundEquation != null) : "The background equation must not be null.";
        if (extractedIonSignals == null || chromatogram == null || totalIonSignals == null || backgroundEquation == null) {
            throw new PeakException("The extractedIonSignals, chromatogram, totalIonSignals or backgroundEquation must not be null.");
        }
        PeakMassSpectrum peakMassSpectrum = null;
        ITotalScanSignal totalIonSignal = totalIonSignals.getMaxTotalScanSignal();
        if (totalIonSignal != null) {
            int scan = chromatogram.getScanNumber(totalIonSignal.getRetentionTime());
            IScanMSD massSpectrum = excludedIons == null ? extractedIonSignals.getScan(scan) : extractedIonSignals.getScan(scan, excludedIons);
            float actualSignal = massSpectrum.getTotalSignal();
            float backgroundSignal = (float)backgroundEquation.calculateY((double)totalIonSignal.getRetentionTime());
            float correctedSignal = actualSignal - backgroundSignal;
            float percentage = 100.0f / correctedSignal * actualSignal;
            peakMassSpectrum = new PeakMassSpectrum(massSpectrum, percentage);
        }
        return peakMassSpectrum;
    }

    protected static IPeakMassSpectrum getPeakMassSpectrum(IChromatogramMSD chromatogram, ITotalScanSignals totalIonSignals, LinearEquation backgroundEquation, IMarkedIons excludedIons) throws PeakException {
        assert (chromatogram != null) : "The chromatogram must not be null.";
        assert (totalIonSignals != null) : "The total ion signals must not be null.";
        assert (backgroundEquation != null) : "The background equation must not be null.";
        if (chromatogram == null || totalIonSignals == null || backgroundEquation == null) {
            throw new PeakException("The chromatogram, totalIonSignals or backgroundEquation must not be null.");
        }
        PeakMassSpectrum peakMassSpectrum = null;
        ITotalScanSignal totalIonSignal = totalIonSignals.getMaxTotalScanSignal();
        if (totalIonSignal != null) {
            int scan = chromatogram.getScanNumber(totalIonSignal.getRetentionTime());
            IScanMSD massSpectrum = excludedIons == null ? chromatogram.getSupplierScan(scan) : chromatogram.getScan(scan, excludedIons);
            float actualSignal = massSpectrum.getTotalSignal();
            float backgroundSignal = (float)backgroundEquation.calculateY((double)totalIonSignal.getRetentionTime());
            float correctedSignal = actualSignal - backgroundSignal;
            float percentage = 100.0f / correctedSignal * actualSignal;
            peakMassSpectrum = new PeakMassSpectrum(massSpectrum, percentage);
        }
        return peakMassSpectrum;
    }

    protected static IPeakIntensityValues getPeakIntensityValues(ITotalScanSignals peakIntensityTotalIonSignals) throws PeakException {
        assert (peakIntensityTotalIonSignals != null) : "The peak intensity total ion signals must not be null.";
        if (peakIntensityTotalIonSignals == null) {
            throw new PeakException("The peakIntensityTotalIonSignals must not be null.");
        }
        PeakIntensityValues peakIntensityValues = new PeakIntensityValues();
        List signals = peakIntensityTotalIonSignals.getTotalScanSignals();
        for (ITotalScanSignal signal : signals) {
            peakIntensityValues.addIntensityValue(signal.getRetentionTime(), signal.getTotalSignal());
        }
        return peakIntensityValues;
    }

    protected static ITotalScanSignals adjustTotalIonSignals(ITotalScanSignals totalIonSignals, LinearEquation backgroundEquation) throws PeakException {
        assert (totalIonSignals != null) : "The total ion signals must not be null.";
        assert (backgroundEquation != null) : "The background equation must not be null.";
        if (totalIonSignals == null || backgroundEquation == null) {
            throw new PeakException("The given totalIonSignals or backgroundEquation must not be null.");
        }
        ITotalScanSignals peakIntensityTotalIonSignals = totalIonSignals.makeDeepCopy();
        int start = peakIntensityTotalIonSignals.getStartScan();
        int stop = peakIntensityTotalIonSignals.getStopScan();
        int scan = start;
        while (scan <= stop) {
            ITotalScanSignal totalIonSignal = peakIntensityTotalIonSignals.getTotalScanSignal(scan);
            float adjustedSignal = (float)((double)totalIonSignal.getTotalSignal() - backgroundEquation.calculateY((double)totalIonSignal.getRetentionTime()));
            if (adjustedSignal < 0.0f) {
                adjustedSignal = 0.0f;
            }
            totalIonSignal.setTotalSignal(adjustedSignal);
            ++scan;
        }
        TotalScanSignalsModifier.normalize((ITotalScanSignals)peakIntensityTotalIonSignals, (float)100.0f);
        return peakIntensityTotalIonSignals;
    }

    protected static LinearEquation getBackgroundEquation(ITotalScanSignals totalIonSignals, IScanRange scanRange, IBackgroundAbundanceRange backgroundAbundanceRange) throws PeakException {
        assert (totalIonSignals != null) : "The total ion signals must not be null.";
        assert (scanRange != null) : "The scan range must not be null.";
        assert (backgroundAbundanceRange != null) : "The background abundance range must not be null.";
        if (totalIonSignals == null || scanRange == null || backgroundAbundanceRange == null) {
            throw new PeakException("The given totalIonSignals, scanRange or backgroundAbundanceRange must not be null.");
        }
        ITotalScanSignal totalIonSignal = totalIonSignals.getTotalScanSignal(scanRange.getStartScan());
        Point p1 = new Point((double)totalIonSignal.getRetentionTime(), (double)backgroundAbundanceRange.getStartBackgroundAbundance());
        totalIonSignal = totalIonSignals.getTotalScanSignal(scanRange.getStopScan());
        Point p2 = new Point((double)totalIonSignal.getRetentionTime(), (double)backgroundAbundanceRange.getStopBackgroundAbundance());
        LinearEquation backgroundEquation = Equations.createLinearEquation((IPoint)p1, (IPoint)p2);
        return backgroundEquation;
    }

    protected static ITotalScanSignals getTotalIonSignals(IChromatogramMSD chromatogram, IScanRange scanRange, IMarkedIons excludedIons) throws PeakException {
        assert (chromatogram != null) : "The chromatogram must not be null.";
        assert (scanRange != null) : "The scan range must not be null.";
        assert (excludedIons != null) : "The excluded ions must not be null.";
        if (chromatogram == null || scanRange == null || excludedIons == null) {
            throw new PeakException("The given values must not be null.");
        }
        try {
            TotalIonSignalExtractor totalIonSignalExtractor = new TotalIonSignalExtractor(chromatogram);
            return totalIonSignalExtractor.getTotalIonSignals(scanRange.getStartScan(), scanRange.getStopScan(), excludedIons);
        }
        catch (ChromatogramIsNullException chromatogramIsNullException) {
            throw new PeakException("The chromatogram must not be null.");
        }
    }

    protected static ITotalScanSignals getTotalIonSignals(IChromatogramMSD chromatogram, IScanRange scanRange) throws PeakException {
        assert (chromatogram != null) : "The chromatogram must not be null.";
        assert (scanRange != null) : "The scan range must not be null.";
        if (chromatogram == null || scanRange == null) {
            throw new PeakException("The given values must not be null.");
        }
        try {
            TotalScanSignalExtractor totalIonSignalExtractor = new TotalScanSignalExtractor((IChromatogram)chromatogram);
            return totalIonSignalExtractor.getTotalScanSignals(scanRange.getStartScan(), scanRange.getStopScan());
        }
        catch (ChromatogramIsNullException chromatogramIsNullException) {
            throw new PeakException("The chromatogram must not be null.");
        }
    }

    protected static IBackgroundAbundanceRange checkBackgroundAbundanceRange(ITotalScanSignals totalIonSignals, IScanRange scanRange, IBackgroundAbundanceRange backgroundAbundanceRange) throws PeakException {
        float background = 0.0f;
        float signal = 0.0f;
        float startBackgroundAbundance = 0.0f;
        float stopBackgroundAbundance = 0.0f;
        boolean adjustBackgroundAbundance = false;
        if (totalIonSignals == null || scanRange == null || backgroundAbundanceRange == null) {
            throw new PeakException("The given values must not be null.");
        }
        ITotalScanSignal totalIonSignal = totalIonSignals.getTotalScanSignal(scanRange.getStartScan());
        if (totalIonSignal != null) {
            background = backgroundAbundanceRange.getStartBackgroundAbundance();
            if (background <= (signal = totalIonSignal.getTotalSignal())) {
                startBackgroundAbundance = background;
            } else {
                startBackgroundAbundance = signal;
                adjustBackgroundAbundance = true;
            }
        } else {
            adjustBackgroundAbundance = true;
        }
        totalIonSignal = totalIonSignals.getTotalScanSignal(scanRange.getStopScan());
        if (totalIonSignal != null) {
            background = backgroundAbundanceRange.getStopBackgroundAbundance();
            if (background <= (signal = totalIonSignal.getTotalSignal())) {
                stopBackgroundAbundance = background;
            } else {
                stopBackgroundAbundance = signal;
                adjustBackgroundAbundance = true;
            }
        } else {
            adjustBackgroundAbundance = true;
        }
        if (adjustBackgroundAbundance) {
            backgroundAbundanceRange = new BackgroundAbundanceRange(startBackgroundAbundance, stopBackgroundAbundance);
        }
        return backgroundAbundanceRange;
    }

    protected static void checkScanRange(IChromatogramMSD chromatogram, IScanRange scanRange) throws PeakException {
        assert (chromatogram != null) : "The chromatogram must not be null.";
        assert (scanRange != null) : "The scan range must not be null.";
        if (chromatogram == null || scanRange == null) {
            throw new PeakException("The given chromatogram or scanRange must not be null.");
        }
        if (scanRange.getStartScan() < 1 || scanRange.getStopScan() > chromatogram.getNumberOfScans()) {
            throw new PeakException("The given scan range is out of chromatogram borders.");
        }
    }

    protected static void checkScanRange(IExtractedIonSignals extractedIonSignals, IScanRange scanRange) throws PeakException {
        assert (extractedIonSignals != null) : "The extracted ion signals instance must not be null.";
        assert (scanRange != null) : "The scan range must not be null.";
        if (scanRange == null || extractedIonSignals == null) {
            throw new PeakException("The given scanRange or extractedIonSignals must not be null.");
        }
        if (scanRange.getStartScan() < extractedIonSignals.getStartScan() || scanRange.getStopScan() > extractedIonSignals.getStopScan()) {
            throw new PeakException("The given scan range is out of chromatogram borders.");
        }
    }

    protected static void validateScanRange(IScanRange scanRange) throws PeakException {
        if (scanRange == null) {
            throw new PeakException("The scan range must not be null.");
        }
    }

    protected static void validateBackgroundAbundanceRange(IBackgroundAbundanceRange backgroundAbundanceRange) throws PeakException {
        if (backgroundAbundanceRange == null) {
            throw new PeakException("The background abundance range must not be null.");
        }
    }

    protected static void validatePeakMassSpectrum(IPeakMassSpectrum peakMassSpectrum) throws PeakException {
        if (peakMassSpectrum == null) {
            throw new PeakException("The peak mass spectrum must not be null.");
        }
    }

    protected static void validateTotalIonSignals(ITotalScanSignals totalIonSignals) throws PeakException {
        if (totalIonSignals == null) {
            throw new PeakException("The total ion signals must not be null.");
        }
    }

    protected static void validateExcludedIons(IMarkedIons excludedIons) throws PeakException {
        if (excludedIons == null) {
            throw new PeakException("The excluded ions must not be null.");
        }
    }

    protected static void validateChromatogram(IChromatogramMSD chromatogram) throws PeakException {
        if (chromatogram == null) {
            throw new PeakException("The chromatogram must not be null.");
        }
    }

    protected static void validateExtractedIonSignals(IExtractedIonSignals extractedIonSignals) throws PeakException {
        if (extractedIonSignals == null) {
            throw new PeakException("The extracted ion signals instance must not be null.");
        }
    }
}

