/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.rcp.ui.icons.core;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.MissingResourceException;
import org.eclipse.chemclipse.rcp.ui.icons.core.IApplicationImage;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Image;
import org.osgi.framework.Bundle;

public abstract class AbstractApplicationImage
implements IApplicationImage {
    private Bundle bundle;

    public AbstractApplicationImage(Bundle bundle) {
        this.bundle = bundle;
    }

    @Override
    public Image getImage(String fileName, String size) {
        Image image = JFaceResources.getImageRegistry().get(fileName);
        if (image == null) {
            this.addIconImageDescriptor(fileName, size);
            image = JFaceResources.getImageRegistry().get(fileName);
        }
        return image;
    }

    @Override
    public ImageDescriptor getImageDescriptor(String fileName, String size) {
        ImageDescriptor imageDescriptor = null;
        imageDescriptor = JFaceResources.getImageRegistry().getDescriptor(fileName);
        if (imageDescriptor == null) {
            this.addIconImageDescriptor(fileName, size);
            imageDescriptor = JFaceResources.getImageRegistry().getDescriptor(fileName);
        }
        return imageDescriptor;
    }

    @Override
    public InputStream getImageAsInputStream(String fileName, String size) throws IOException {
        InputStream inputStream = null;
        URL url = FileLocator.find((Bundle)this.bundle, (IPath)new Path("icons/" + size + "/" + fileName), null);
        inputStream = url.openConnection().getInputStream();
        return inputStream;
    }

    private boolean addIconImageDescriptor(String fileName, String size) {
        try {
            URL fileLocation = FileLocator.find((Bundle)this.bundle, (IPath)new Path("icons/" + size + "/" + fileName), null);
            ImageDescriptor imageDescriptor = ImageDescriptor.createFromURL((URL)fileLocation);
            JFaceResources.getImageRegistry().put(fileName, imageDescriptor);
        }
        catch (MissingResourceException missingResourceException) {
            return false;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        return true;
    }
}

