/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.model.support;

import org.eclipse.chemclipse.model.support.IScanRange;

public class ScanRange
implements IScanRange {
    private int startScan;
    private int stopScan;

    public ScanRange(int startScan, int stopScan) {
        if (startScan > stopScan) {
            int tmp = startScan;
            startScan = stopScan;
            stopScan = tmp;
        }
        if (startScan < 1 || startScan > Integer.MAX_VALUE) {
            startScan = 1;
        }
        if (stopScan > Integer.MAX_VALUE || stopScan < 1) {
            stopScan = Integer.MAX_VALUE;
        }
        this.startScan = startScan;
        this.stopScan = stopScan;
    }

    @Override
    public int getStartScan() {
        return this.startScan;
    }

    @Override
    public int getStopScan() {
        return this.stopScan;
    }

    @Override
    public int getWidth() {
        return this.stopScan - this.startScan + 1;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        ScanRange otherRange = (ScanRange)other;
        return this.getStartScan() == otherRange.getStartScan() && this.getStopScan() == otherRange.getStopScan();
    }

    public int hashCode() {
        return 7 * Integer.valueOf(this.getStartScan()).hashCode() + 11 * Integer.valueOf(this.getStopScan()).hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getName());
        builder.append("[");
        builder.append("startScan=" + this.getStartScan());
        builder.append(",");
        builder.append("stopScan=" + this.getStopScan());
        builder.append("]");
        return builder.toString();
    }
}

