/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.model.signals;

import java.util.Arrays;
import java.util.List;
import org.eclipse.chemclipse.model.exceptions.CalculationException;
import org.eclipse.chemclipse.model.exceptions.NoTotalSignalStoredException;
import org.eclipse.chemclipse.model.signals.ITotalScanSignal;
import org.eclipse.chemclipse.model.signals.ITotalScanSignals;
import org.eclipse.chemclipse.numeric.statistics.Calculations;
import org.eclipse.chemclipse.numeric.statistics.WindowSize;

public class TotalScanSignalsModifier {
    private TotalScanSignalsModifier() {
    }

    public static void normalize(ITotalScanSignals totalIonSignals) {
        TotalScanSignalsModifier.normalize(totalIonSignals, 1000.0f);
    }

    public static void normalize(ITotalScanSignals totalIonSignals, float base) {
        if (totalIonSignals == null) {
            return;
        }
        if (base < 1.0f) {
            return;
        }
        double max = totalIonSignals.getMaxSignal();
        double factor = 0.0;
        if (max != 0.0) {
            factor = (double)base / max;
        }
        List<ITotalScanSignal> signals = totalIonSignals.getTotalScanSignals();
        for (ITotalScanSignal signal : signals) {
            float totalSignal = (float)(factor * (double)signal.getTotalSignal());
            signal.setTotalSignal(totalSignal);
        }
    }

    public static void meanNormalize(ITotalScanSignals totalIonSignals) throws NoTotalSignalStoredException, CalculationException {
        if (totalIonSignals == null || totalIonSignals.size() == 0) {
            throw new NoTotalSignalStoredException("There are no total ion signals stored.");
        }
        float[] allSignals = new float[totalIonSignals.size()];
        List<ITotalScanSignal> signals = totalIonSignals.getTotalScanSignals();
        int i = 0;
        for (ITotalScanSignal signal : signals) {
            allSignals[i++] = signal.getTotalSignal();
        }
        float meanSignal = Math.abs(Calculations.getMean((float[])allSignals));
        if (meanSignal == 0.0f) {
            throw new CalculationException("The mean abundance must not be 0.");
        }
        int startScan = totalIonSignals.getStartScan();
        int stopScan = totalIonSignals.getStopScan();
        int scan = startScan;
        while (scan <= stopScan) {
            ITotalScanSignal totalIonSignal = totalIonSignals.getTotalScanSignal(scan);
            float normalizedAbundance = totalIonSignal.getTotalSignal() / meanSignal;
            if (normalizedAbundance < 0.0f) {
                normalizedAbundance = 0.0f;
            }
            totalIonSignal.setTotalSignal(normalizedAbundance);
            ++scan;
        }
    }

    public static void medianNormalize(ITotalScanSignals totalIonSignals) throws NoTotalSignalStoredException, CalculationException {
        float medianSignal;
        if (totalIonSignals == null || totalIonSignals.size() == 0) {
            throw new NoTotalSignalStoredException("There are no total ion signals stored.");
        }
        float[] allSignals = new float[totalIonSignals.size()];
        List<ITotalScanSignal> signals = totalIonSignals.getTotalScanSignals();
        int i = 0;
        for (ITotalScanSignal signal : signals) {
            allSignals[i++] = signal.getTotalSignal();
        }
        Arrays.sort(allSignals);
        int middle = allSignals.length / 2;
        float f = medianSignal = allSignals.length % 2 == 1 ? allSignals[middle] : (allSignals[middle - 1] + allSignals[middle]) / 2.0f;
        if (medianSignal == 0.0f) {
            throw new CalculationException("The median abundance must not be 0.");
        }
        int startScan = totalIonSignals.getStartScan();
        int stopScan = totalIonSignals.getStopScan();
        int scan = startScan;
        while (scan <= stopScan) {
            ITotalScanSignal totalIonSignal = totalIonSignals.getTotalScanSignal(scan);
            float normalizedAbundance = totalIonSignal.getTotalSignal() / medianSignal;
            if (normalizedAbundance < 0.0f) {
                normalizedAbundance = 0.0f;
            }
            totalIonSignal.setTotalSignal(normalizedAbundance);
            ++scan;
        }
    }

    public static void multiple(ITotalScanSignals totalIonSignals, float multiplier) throws NoTotalSignalStoredException, CalculationException {
        if (totalIonSignals == null || totalIonSignals.size() == 0) {
            throw new NoTotalSignalStoredException("There are no total ion signals stored.");
        }
        int startScan = totalIonSignals.getStartScan();
        int stopScan = totalIonSignals.getStopScan();
        int scan = startScan;
        while (scan <= stopScan) {
            ITotalScanSignal totalIonSignal = totalIonSignals.getTotalScanSignal(scan);
            float normalizedAbundance = totalIonSignal.getTotalSignal() * multiplier;
            if (normalizedAbundance < 0.0f) {
                normalizedAbundance = 0.0f;
            }
            totalIonSignal.setTotalSignal(normalizedAbundance);
            ++scan;
        }
    }

    public static void calculateMovingAverage(ITotalScanSignals totalIonSignals, WindowSize windowSize) {
        if (windowSize == null || totalIonSignals == null) {
            return;
        }
        if (totalIonSignals.size() < windowSize.getSize()) {
            return;
        }
        int diff = windowSize.getSize() / 2;
        int windowStop = windowSize.getSize() - diff;
        int size = totalIonSignals.size() - diff;
        float[] values = new float[windowSize.getSize()];
        int i = diff;
        while (i < size) {
            int j = -diff;
            int k = 0;
            while (j < windowStop) {
                values[k] = totalIonSignals.getTotalScanSignal(i + j + 1).getTotalSignal();
                ++j;
                ++k;
            }
            totalIonSignals.getTotalScanSignal(i + 1).setTotalSignal(Calculations.getMean((float[])values));
            ++i;
        }
    }

    public static void unitSumNormalize(ITotalScanSignals totalIonSignals, double areaSumIntensity) throws NoTotalSignalStoredException {
        if (totalIonSignals == null || totalIonSignals.size() == 0) {
            throw new NoTotalSignalStoredException("There are no total ion signals stored.");
        }
        List<ITotalScanSignal> signals = totalIonSignals.getTotalScanSignals();
        for (ITotalScanSignal signal : signals) {
            float totalSignal = (float)((double)signal.getTotalSignal() / areaSumIntensity);
            signal.setTotalSignal(totalSignal);
        }
    }
}

