/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.model.core;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.model.core.RetentionIndexType;
import org.eclipse.core.runtime.Platform;

public abstract class AbstractScan
implements IScan {
    private static final long serialVersionUID = 642924518234776409L;
    private transient IChromatogram parentChromatogram;
    private int retentionTime = 0;
    private int retentionTimeColumn1 = 0;
    private int retentionTimeColumn2 = 0;
    private float retentionIndex = 0.0f;
    private Map<RetentionIndexType, Float> additionalRetentionIndices = null;
    private int scanNumber = 0;
    private int timeSegmentId = 1;
    private int cycleNumber = 1;
    private boolean isDirty = false;
    private String identifier = "";

    public AbstractScan() {
    }

    public AbstractScan(IScan templateScan) {
        this.parentChromatogram = templateScan.getParentChromatogram();
        this.retentionIndex = templateScan.getRetentionIndex();
        this.scanNumber = templateScan.getScanNumber();
        this.timeSegmentId = templateScan.getTimeSegmentId();
        this.cycleNumber = templateScan.getCycleNumber();
        this.identifier = templateScan.getIdentifier();
        this.isDirty = templateScan.isDirty();
    }

    @Override
    public IChromatogram getParentChromatogram() {
        return this.parentChromatogram;
    }

    @Override
    public void setParentChromatogram(IChromatogram parentChromatogram) {
        this.parentChromatogram = parentChromatogram;
    }

    @Override
    public int getRetentionTime() {
        return this.retentionTime;
    }

    @Override
    public void setRetentionTime(int retentionTime) {
        if (retentionTime >= 0) {
            this.retentionTime = retentionTime;
            this.setDirty(true);
        }
    }

    @Override
    public int getRetentionTimeColumn1() {
        return this.retentionTimeColumn1;
    }

    @Override
    public void setRetentionTimeColumn1(int retentionTimeColumn1) {
        if (retentionTimeColumn1 >= 0) {
            this.retentionTimeColumn1 = retentionTimeColumn1;
            this.setDirty(true);
        }
    }

    @Override
    public int getRetentionTimeColumn2() {
        return this.retentionTimeColumn2;
    }

    @Override
    public void setRetentionTimeColumn2(int retentionTimeColumn2) {
        if (retentionTimeColumn2 >= 0) {
            this.retentionTimeColumn2 = retentionTimeColumn2;
            this.setDirty(true);
        }
    }

    @Override
    public float getRetentionIndex() {
        return this.retentionIndex;
    }

    @Override
    public void setRetentionIndex(float retentionIndex) {
        if (retentionIndex > 0.0f) {
            this.retentionIndex = retentionIndex;
            this.setDirty(true);
        }
    }

    @Override
    public boolean hasAdditionalRetentionIndices() {
        if (this.additionalRetentionIndices == null) {
            return false;
        }
        return this.additionalRetentionIndices.size() > 0;
    }

    @Override
    public float getRetentionIndex(RetentionIndexType retentionIndexType) {
        if (this.additionalRetentionIndices != null && this.additionalRetentionIndices.containsKey((Object)retentionIndexType)) {
            return this.additionalRetentionIndices.get((Object)retentionIndexType).floatValue();
        }
        return 0.0f;
    }

    @Override
    public void setRetentionIndex(RetentionIndexType retentionIndexType, float retentionIndex) {
        if (this.additionalRetentionIndices == null) {
            this.additionalRetentionIndices = new HashMap<RetentionIndexType, Float>();
        }
        this.additionalRetentionIndices.put(retentionIndexType, Float.valueOf(retentionIndex));
    }

    @Override
    public Map<RetentionIndexType, Float> getRetentionIndicesTyped() {
        if (this.additionalRetentionIndices == null) {
            return new HashMap<RetentionIndexType, Float>();
        }
        return new HashMap<RetentionIndexType, Float>(this.additionalRetentionIndices);
    }

    @Override
    public int getScanNumber() {
        return this.scanNumber;
    }

    @Override
    public void setScanNumber(int scanNumber) {
        if (scanNumber >= 0) {
            this.scanNumber = scanNumber;
            this.setDirty(true);
        }
    }

    @Override
    public int getTimeSegmentId() {
        return this.timeSegmentId;
    }

    @Override
    public void setTimeSegmentId(int timeSegmentId) {
        this.timeSegmentId = timeSegmentId;
    }

    @Override
    public int getCycleNumber() {
        return this.cycleNumber;
    }

    @Override
    public void setCycleNumber(int cycleNumber) {
        this.cycleNumber = cycleNumber;
    }

    @Override
    public boolean isDirty() {
        return this.isDirty;
    }

    @Override
    public void setDirty(boolean isDirty) {
        this.isDirty = isDirty;
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public void setIdentifier(String identifier) {
        if (identifier != null) {
            this.identifier = identifier;
        }
    }

    public Object getAdapter(Class adapter) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public boolean equals(Object otherObject) {
        return super.equals(otherObject);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(super.toString());
        builder.append(this.getClass().getName());
        builder.append("[");
        builder.append("retentionIndex=" + this.retentionIndex);
        builder.append(",");
        builder.append("retentionTime=" + this.retentionTime);
        builder.append(",");
        builder.append("scanNumber=" + this.scanNumber);
        builder.append("]");
        return builder.toString();
    }
}

