/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.model.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.core.IIntegrationEntry;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.core.IPeakModel;
import org.eclipse.chemclipse.model.core.PeakType;
import org.eclipse.chemclipse.model.exceptions.PeakException;
import org.eclipse.chemclipse.model.quantitation.IInternalStandard;
import org.eclipse.chemclipse.model.quantitation.IQuantitationEntry;
import org.eclipse.chemclipse.model.support.IIntegrationConstraints;
import org.eclipse.chemclipse.model.support.IntegrationConstraints;
import org.eclipse.chemclipse.model.targets.AbstractPeakTargets;

public abstract class AbstractPeak
extends AbstractPeakTargets
implements IPeak {
    private static final long serialVersionUID = -491170278267735090L;
    private String modelDescription = "";
    private PeakType peakType = PeakType.DEFAULT;
    private int suggestedNumberOfComponents = 0;
    private String integratorDescription = "";
    private String detectorDescription = "";
    private String quantifierDescription = "";
    private boolean activeForAnalysis = true;
    private List<? extends IIntegrationEntry> integrationEntries;
    private IIntegrationConstraints integrationConstraints = new IntegrationConstraints();
    private List<IQuantitationEntry> quantitationEntries;
    private List<IInternalStandard> internalStandards;

    public AbstractPeak() {
        this.integrationEntries = new ArrayList<IIntegrationEntry>();
        this.quantitationEntries = new ArrayList<IQuantitationEntry>();
        this.internalStandards = new ArrayList<IInternalStandard>();
    }

    @Override
    public String getModelDescription() {
        return this.modelDescription;
    }

    @Override
    public void setModelDescription(String modelDescription) {
        if (modelDescription != null) {
            this.modelDescription = modelDescription;
        }
    }

    @Override
    public PeakType getPeakType() {
        return this.peakType;
    }

    @Override
    public void setPeakType(PeakType peakType) {
        if (peakType != null) {
            this.peakType = peakType;
        }
    }

    @Override
    public int getSuggestedNumberOfComponents() {
        return this.suggestedNumberOfComponents;
    }

    @Override
    public void setSuggestedNumberOfComponents(int suggestedNumberOfComponents) {
        this.suggestedNumberOfComponents = suggestedNumberOfComponents;
    }

    @Override
    public String getIntegratorDescription() {
        return this.integratorDescription;
    }

    @Override
    public void setIntegratorDescription(String integratorDescription) {
        if (integratorDescription != null) {
            this.integratorDescription = integratorDescription;
        }
    }

    @Override
    public String getDetectorDescription() {
        return this.detectorDescription;
    }

    @Override
    public void setDetectorDescription(String detectorDescription) {
        if (detectorDescription != null) {
            this.detectorDescription = detectorDescription;
        }
    }

    @Override
    public IIntegrationConstraints getIntegrationConstraints() {
        return this.integrationConstraints;
    }

    @Override
    public double getIntegratedArea() {
        double integratedArea = 0.0;
        if (this.integrationEntries.size() > 0) {
            for (IIntegrationEntry iIntegrationEntry : this.integrationEntries) {
                integratedArea += iIntegrationEntry.getIntegratedArea();
            }
        }
        return integratedArea;
    }

    @Override
    public List<? extends IIntegrationEntry> getIntegrationEntries() {
        return this.integrationEntries;
    }

    @Override
    public void setIntegratedArea(List<? extends IIntegrationEntry> integrationEntries, String integratorDescription) {
        if (integrationEntries != null) {
            this.setIntegratorDescription(integratorDescription);
            this.integrationEntries = integrationEntries;
        }
    }

    @Override
    public String getQuantifierDescription() {
        return this.quantifierDescription;
    }

    @Override
    public void setQuantifierDescription(String quantifierDescription) {
        this.quantifierDescription = quantifierDescription;
    }

    @Override
    public void addQuantitationEntry(IQuantitationEntry quantitationEntry) {
        this.quantitationEntries.add(quantitationEntry);
    }

    @Override
    public void removeQuantitationEntry(IQuantitationEntry quantitationEntry) {
        this.quantitationEntries.remove(quantitationEntry);
    }

    @Override
    public void removeQuantitationEntries(List<IQuantitationEntry> quantitationEntriesToRemove) {
        this.quantitationEntries.removeAll(quantitationEntriesToRemove);
    }

    @Override
    public List<IQuantitationEntry> getQuantitationEntries() {
        return this.quantitationEntries;
    }

    @Override
    public void removeAllQuantitationEntries() {
        this.quantitationEntries.clear();
    }

    @Override
    public void removeAllIntegrationEntries() {
        this.integrationEntries.clear();
    }

    @Override
    public boolean isActiveForAnalysis() {
        return this.activeForAnalysis;
    }

    @Override
    public void setActiveForAnalysis(boolean activeForAnalysis) {
        this.activeForAnalysis = activeForAnalysis;
    }

    protected void validatePeakModel(IPeakModel peakModel) throws IllegalArgumentException {
        if (peakModel == null) {
            throw new IllegalArgumentException("The peak model must not be null");
        }
    }

    protected void validateChromatogram(IChromatogram chromatogram) throws IllegalArgumentException {
        if (chromatogram == null) {
            throw new IllegalArgumentException("The parent chromatogram must not be null");
        }
    }

    protected void validateRetentionTimes(IChromatogram chromatogram, IPeakModel peakModel) throws PeakException {
        int start = chromatogram.getStartRetentionTime();
        int stop = chromatogram.getStopRetentionTime();
        if (peakModel.getStartRetentionTime() < start || peakModel.getStopRetentionTime() > stop) {
            throw new PeakException("The start and stop retention times of the peak must be within the chromatogram retention time borders.");
        }
    }

    @Override
    public List<IInternalStandard> getInternalStandards() {
        return this.internalStandards;
    }

    @Override
    public void addInternalStandard(IInternalStandard internalStandard) {
        this.internalStandards.add(internalStandard);
    }

    @Override
    public void addInternalStandards(List<IInternalStandard> internalStandards) {
        this.internalStandards.addAll(internalStandards);
    }

    @Override
    public void removeInternalStandard(IInternalStandard internalStandard) {
        this.internalStandards.remove(internalStandard);
    }
}

