/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.csd.ui.views;

import org.eclipse.chemclipse.csd.model.core.selection.IChromatogramSelectionCSD;
import org.eclipse.chemclipse.ux.extension.csd.ui.views.IChromatogramSelectionCSDView;
import org.eclipse.chemclipse.ux.extension.ui.definitions.ChromatogramType;
import org.eclipse.chemclipse.ux.extension.ui.explorer.AbstractSelectionView;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public abstract class AbstractChromatogramSelectionCSDView
extends AbstractSelectionView
implements IChromatogramSelectionCSDView {
    private IChromatogramSelectionCSD chromatogramSelection;
    private IEventBroker eventBroker;
    private EventHandler eventHandler;

    public AbstractChromatogramSelectionCSDView(MPart part, EPartService partService, IEventBroker eventBroker) {
        super(part, partService);
        this.eventBroker = eventBroker;
        this.subscribe();
    }

    @Override
    public IChromatogramSelectionCSD getChromatogramSelection() {
        if (this.chromatogramSelection == null) {
            this.chromatogramSelection = ChromatogramType.getChromatogramSelectionCSD();
        }
        return this.chromatogramSelection;
    }

    @Override
    public void setChromatogramSelection(IChromatogramSelectionCSD chromatogramSelection) {
        this.chromatogramSelection = chromatogramSelection;
    }

    private void subscribe() {
        if (this.eventBroker != null) {
            this.eventHandler = new EventHandler(){

                public void handleEvent(Event event) {
                    AbstractChromatogramSelectionCSDView.this.chromatogramSelection = (IChromatogramSelectionCSD)event.getProperty("ChromatogramSelection");
                    boolean forceReload = (Boolean)event.getProperty("ForceReload");
                    AbstractChromatogramSelectionCSDView.this.update(AbstractChromatogramSelectionCSDView.this.chromatogramSelection, forceReload);
                }
            };
            this.eventBroker.subscribe("chromatogram/csd/update/chromatogramselection", this.eventHandler);
        }
    }

    public void unsubscribe() {
        if (this.eventBroker != null && this.eventHandler != null) {
            this.eventBroker.unsubscribe(this.eventHandler);
        }
    }
}

