/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.data.convert;

import java.text.SimpleDateFormat;
import java.util.TimeZone;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.nebula.widgets.nattable.Messages;
import org.eclipse.nebula.widgets.nattable.data.convert.ConversionFailedException;
import org.eclipse.nebula.widgets.nattable.data.convert.DisplayConverter;
import org.eclipse.nebula.widgets.nattable.util.ObjectUtils;

public class DefaultDateDisplayConverter
extends DisplayConverter {
    private static final Log log = LogFactory.getLog(DefaultDateDisplayConverter.class);
    private SimpleDateFormat dateFormat;

    public DefaultDateDisplayConverter() {
        this(null, null);
    }

    public DefaultDateDisplayConverter(TimeZone timeZone) {
        this(null, timeZone);
    }

    public DefaultDateDisplayConverter(String dateFormat) {
        this(dateFormat, null);
    }

    public DefaultDateDisplayConverter(String dateFormat, TimeZone timeZone) {
        this.dateFormat = dateFormat != null ? new SimpleDateFormat(dateFormat) : new SimpleDateFormat();
        if (timeZone != null) {
            this.dateFormat.setTimeZone(timeZone);
        }
    }

    @Override
    public Object canonicalToDisplayValue(Object canonicalValue) {
        try {
            if (ObjectUtils.isNotNull(canonicalValue)) {
                return this.dateFormat.format(canonicalValue);
            }
        }
        catch (Exception e) {
            log.warn((Object)e);
        }
        return canonicalValue;
    }

    @Override
    public Object displayToCanonicalValue(Object displayValue) {
        try {
            return this.dateFormat.parse(displayValue.toString());
        }
        catch (Exception e) {
            throw new ConversionFailedException(Messages.getString("DefaultDateDisplayConverter.failure", new Object[]{displayValue, this.dateFormat.toPattern()}), e);
        }
    }
}

