/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.odaconsumer;

import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.logging.Level;
import org.eclipse.birt.data.engine.i18n.DataResourceHandle;
import org.eclipse.birt.data.engine.odaconsumer.DataTypeUtil;
import org.eclipse.birt.data.engine.odaconsumer.LogHelper;
import org.eclipse.datatools.connectivity.oda.IBlob;
import org.eclipse.datatools.connectivity.oda.IClob;

public class ParameterHint {
    private String m_name;
    private String m_nativeName;
    private int m_position;
    private Class m_dataType;
    private int m_nativeDataType = 0;
    private boolean m_isInputOptional;
    private boolean m_isMultiInputValuesAllowed = false;
    private Object m_defaultInputValue;
    private boolean m_isInputMode;
    private boolean m_isOutputMode;
    private boolean m_isNullable;
    private static final int UNKNOWN_NATIVE_TYPE = 0;
    private static String sm_className = ParameterHint.class.getName();
    private static String sm_loggerName = "org.eclipse.birt.data.engine.odaconsumer";
    private static LogHelper sm_logger = LogHelper.getInstance(sm_loggerName);

    public ParameterHint(String parameterName, boolean isInputMode, boolean isOutputMode) {
        if (sm_logger.isLoggingEnterExitLevel()) {
            sm_logger.entering(sm_className, "ParameterHint( String, boolean, boolean )", new Object[]{parameterName, isInputMode, isOutputMode});
        }
        if (parameterName == null || parameterName.length() == 0) {
            String localizedMessage = DataResourceHandle.getInstance().getMessage("odaconsumer.ParameterNameCannotBeEmptyOrNull");
            sm_logger.logp(Level.SEVERE, sm_className, "ParameterHint( String, boolean, boolean )", "The given parameter is null or empty.");
            throw new IllegalArgumentException(localizedMessage);
        }
        this.m_name = parameterName;
        this.m_isInputMode = isInputMode;
        this.m_isOutputMode = isOutputMode;
        this.m_isInputOptional = true;
        this.m_isNullable = true;
        sm_logger.exiting(sm_className, "ParameterHint( String, boolean, boolean )", this);
    }

    public String getName() {
        return this.m_name;
    }

    public void setPosition(int position) {
        if (position < 1) {
            String localizedMessage = DataResourceHandle.getInstance().getMessage("odaconsumer.ParameterPositionIsOneBased");
            sm_logger.logp(Level.SEVERE, sm_className, "setPosition( int )", "Invalid parameter position {0} ", position);
            throw new IllegalArgumentException(localizedMessage);
        }
        this.m_position = position;
    }

    public int getPosition() {
        return this.m_position;
    }

    public void setDataType(Class dataType) {
        boolean isValid = false;
        if (dataType == null || dataType == Integer.class || dataType == Double.class || dataType == String.class || dataType == BigDecimal.class || dataType == Date.class || dataType == java.sql.Date.class || dataType == Time.class || dataType == Timestamp.class || dataType == IBlob.class || dataType == IClob.class || dataType == Boolean.class || dataType == Object.class) {
            isValid = true;
        }
        if (isValid && this.isInputMode() && dataType != null && (dataType == IBlob.class || dataType == IClob.class)) {
            isValid = false;
        }
        if (!isValid) {
            String localizedMessage = DataResourceHandle.getInstance().getMessage("odaconsumer.UnsupportedParameterValueType", new Object[]{dataType});
            sm_logger.logp(Level.SEVERE, sm_className, "setDataType( Class )", "Invalid parameter data type {0}.", dataType);
            throw new IllegalArgumentException(localizedMessage);
        }
        this.m_dataType = dataType;
    }

    public Class getDataType() {
        return this.m_dataType;
    }

    public void setNativeDataType(int typeCode) {
        this.m_nativeDataType = typeCode;
    }

    public int getNativeDataType() {
        return this.m_nativeDataType;
    }

    public void setIsInputOptional(boolean isInputOptional) {
        if (this.m_isInputMode) {
            this.m_isInputOptional = isInputOptional;
        }
    }

    public boolean isInputOptional() {
        return this.m_isInputMode ? this.m_isInputOptional : true;
    }

    public void setIsNullable(boolean isNullable) {
        this.m_isNullable = isNullable;
    }

    public boolean isNullable() {
        return this.m_isNullable;
    }

    public void setDefaultInputValue(Object defaultInputValue) {
        if (this.m_isInputMode) {
            this.m_defaultInputValue = defaultInputValue;
        }
    }

    public Object getDefaultInputValue() {
        return this.m_isInputMode ? this.m_defaultInputValue : null;
    }

    public boolean isInputMode() {
        return this.m_isInputMode;
    }

    public boolean isOutputMode() {
        return this.m_isOutputMode;
    }

    public void setNativeName(String nativeName) {
        this.m_nativeName = nativeName;
    }

    public String getNativeName() {
        return this.m_nativeName;
    }

    public void setMultiInputValuesAllowed(boolean isMultiInputValuesAllowed) {
        if (this.m_isInputMode) {
            this.m_isMultiInputValuesAllowed = isMultiInputValuesAllowed;
        }
    }

    public boolean isMultiInputValuesAllowed() {
        return this.m_isInputMode ? this.m_isMultiInputValuesAllowed : false;
    }

    void updateHint(ParameterHint hint) {
        sm_logger.entering(sm_className, "updateHint( ParameterHint )", hint);
        this.m_name = hint.m_name;
        if (hint.m_nativeName != null) {
            this.m_nativeName = hint.m_nativeName;
        }
        if (hint.m_position != 0) {
            this.m_position = hint.m_position;
        }
        if (hint.m_dataType != null) {
            this.m_dataType = hint.m_dataType;
        }
        if (hint.m_nativeDataType != 0) {
            this.m_nativeDataType = hint.m_nativeDataType;
        }
        this.m_isInputOptional = hint.m_isInputOptional;
        this.m_defaultInputValue = hint.m_defaultInputValue;
        this.m_isInputMode = hint.m_isInputMode;
        this.m_isOutputMode = hint.m_isOutputMode;
        this.m_isNullable = hint.m_isNullable;
        sm_logger.exiting(sm_className, "updateHint( ParameterHint )", this);
    }

    public Class getEffectiveDataType(String odaDataSourceId, String dataSetType) {
        return DataTypeUtil.toTypeClass(this.getEffectiveOdaType(odaDataSourceId, dataSetType));
    }

    int getEffectiveOdaType(String odaDataSourceId, String dataSetType) {
        int odaType;
        if (this.getNativeDataType() != 0 && (odaType = DataTypeUtil.toOdaType(this.getNativeDataType(), odaDataSourceId, dataSetType)) != 0) {
            return odaType;
        }
        Class typeInHint = this.getDataType();
        return DataTypeUtil.toOdaType(typeInHint);
    }
}

