/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.edit.supplier.snip.calculator;

import org.eclipse.core.runtime.IProgressMonitor;

public class SnipCalculator {
    public float[] calculateBaselineIntensityValues(float[] intensityValues, int iterations, IProgressMonitor monitor) {
        int size = intensityValues.length;
        float[] tmp = new float[size];
        int i = 1;
        while (i <= iterations) {
            monitor.subTask("Iteration: " + i);
            int j = i;
            while (j < size - i) {
                float b = (intensityValues[j - i] + intensityValues[j + i]) / 2.0f;
                float a = intensityValues[j];
                if (b < a) {
                    a = b;
                }
                tmp[j] = a;
                ++j;
            }
            j = i;
            while (j < size - i) {
                intensityValues[j] = tmp[j];
                ++j;
            }
            ++i;
        }
        return intensityValues;
    }
}

