/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.serviceregistry;

import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;
import org.eclipse.osgi.internal.debug.Debug;
import org.eclipse.osgi.internal.framework.BundleContextImpl;
import org.eclipse.osgi.internal.messages.Msg;
import org.eclipse.osgi.internal.serviceregistry.ServiceFactoryUse;
import org.eclipse.osgi.internal.serviceregistry.ServiceRegistrationImpl;

public class PrototypeServiceFactoryUse<S>
extends ServiceFactoryUse<S> {
    private final Set<S> serviceObjects = Collections.newSetFromMap(new IdentityHashMap());

    PrototypeServiceFactoryUse(BundleContextImpl context, ServiceRegistrationImpl<S> registration) {
        super(context, registration);
    }

    @Override
    S newServiceObject() {
        Object service;
        assert (Thread.holdsLock(this));
        if (this.debug.DEBUG_SERVICES) {
            Debug.println("getServiceObject[factory=" + this.registration.getBundle() + "](" + this.context.getBundleImpl() + "," + this.registration + ")");
        }
        if ((service = this.factoryGetService()) == null) {
            return null;
        }
        this.serviceObjects.add(service);
        return service;
    }

    @Override
    boolean releaseServiceObject(S service) {
        assert (Thread.holdsLock(this));
        if (service == null || !this.serviceObjects.remove(service)) {
            throw new IllegalArgumentException(Msg.SERVICE_OBJECTS_UNGET_ARGUMENT_EXCEPTION);
        }
        if (this.debug.DEBUG_SERVICES) {
            Debug.println("ungetService[factory=" + this.registration.getBundle() + "](" + this.context.getBundleImpl() + "," + this.registration + ")");
        }
        this.factoryUngetService(service);
        return true;
    }

    @Override
    void release() {
        super.release();
        for (S service : this.serviceObjects) {
            if (this.debug.DEBUG_SERVICES) {
                Debug.println("releaseService[factory=" + this.registration.getBundle() + "](" + this.context.getBundleImpl() + "," + this.registration + ")");
            }
            this.factoryUngetService(service);
        }
        this.serviceObjects.clear();
    }

    @Override
    boolean isEmpty() {
        return super.isEmpty() && this.serviceObjects.isEmpty();
    }
}

