/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.actions;

import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.search.JavaSearchScopeFactory;
import org.eclipse.jdt.internal.ui.search.SearchMessages;
import org.eclipse.jdt.ui.actions.FindImplementorsAction;
import org.eclipse.jdt.ui.search.ElementQuerySpecification;
import org.eclipse.jdt.ui.search.QuerySpecification;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;

public class FindImplementorsInProjectAction
extends FindImplementorsAction {
    public FindImplementorsInProjectAction(IWorkbenchSite site) {
        super(site);
    }

    public FindImplementorsInProjectAction(JavaEditor editor) {
        super(editor);
    }

    void init() {
        this.setText(SearchMessages.Search_FindImplementorsInProjectAction_label);
        this.setToolTipText(SearchMessages.Search_FindImplementorsInProjectAction_tooltip);
        this.setImageDescriptor(JavaPluginImages.DESC_OBJS_SEARCH_DECL);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.ui.find_implementors_in_project_action");
    }

    QuerySpecification createQuery(IJavaElement element) throws JavaModelException {
        String description;
        IJavaSearchScope scope;
        JavaSearchScopeFactory factory = JavaSearchScopeFactory.getInstance();
        JavaEditor editor = this.getEditor();
        boolean isInsideJRE = factory.isInsideJRE(element);
        if (editor != null) {
            scope = factory.createJavaProjectSearchScope(editor.getEditorInput(), isInsideJRE);
            description = factory.getProjectScopeDescription(editor.getEditorInput(), isInsideJRE);
        } else {
            scope = factory.createJavaProjectSearchScope(element.getJavaProject(), isInsideJRE);
            description = factory.getProjectScopeDescription(element.getJavaProject(), isInsideJRE);
        }
        return new ElementQuerySpecification(element, this.getLimitTo(), scope, description);
    }
}

