/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.wsd.ui.editors;

import java.io.File;
import java.io.FileNotFoundException;
import java.lang.reflect.InvocationTargetException;
import java.text.DecimalFormat;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.chemclipse.converter.exceptions.FileIsEmptyException;
import org.eclipse.chemclipse.converter.exceptions.FileIsNotReadableException;
import org.eclipse.chemclipse.converter.exceptions.NoChromatogramConverterAvailableException;
import org.eclipse.chemclipse.converter.exceptions.NoConverterAvailableException;
import org.eclipse.chemclipse.converter.processing.chromatogram.IChromatogramExportConverterProcessingInfo;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.core.IChromatogramOverview;
import org.eclipse.chemclipse.model.exceptions.ChromatogramIsNullException;
import org.eclipse.chemclipse.processing.core.exceptions.TypeCastException;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.support.text.ValueFormat;
import org.eclipse.chemclipse.ux.extension.ui.dialogs.ReferencedChromatogramDialog;
import org.eclipse.chemclipse.ux.extension.wsd.ui.editors.IChromatogramEditorWSD;
import org.eclipse.chemclipse.ux.extension.wsd.ui.internal.support.ChromatogramImportRunnable;
import org.eclipse.chemclipse.ux.extension.wsd.ui.support.ChromatogramFileSupport;
import org.eclipse.chemclipse.ux.extension.wsd.ui.support.ChromatogramSupport;
import org.eclipse.chemclipse.wsd.converter.chromatogram.ChromatogramConverterWSD;
import org.eclipse.chemclipse.wsd.model.core.IChromatogramWSD;
import org.eclipse.chemclipse.wsd.model.core.selection.ChromatogramSelectionWSD;
import org.eclipse.chemclipse.wsd.model.core.selection.IChromatogramSelectionWSD;
import org.eclipse.chemclipse.wsd.model.notifier.ChromatogramSelectionWSDUpdateNotifier;
import org.eclipse.chemclipse.wsd.model.notifier.IChromatogramSelectionWSDUpdateNotifier;
import org.eclipse.chemclipse.wsd.swt.ui.components.chromatogram.EditorChromatogramUI;
import org.eclipse.chemclipse.wsd.swt.ui.components.chromatogram.MarkedWavelengthsChooser;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MDirtyable;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class ChromatogramEditorWSD
implements IChromatogramEditorWSD,
IChromatogramSelectionWSDUpdateNotifier {
    public static final String ID = "org.eclipse.chemclipse.ux.extension.wsd.ui.part.chromatogramEditor";
    public static final String CONTRIBUTION_URI = "bundleclass://org.eclipse.chemclipse.ux.extension.wsd.ui/org.eclipse.chemclipse.ux.extension.wsd.ui.editors.ChromatogramEditorWSD";
    public static final String ICON_URI = "platform:/plugin/org.eclipse.chemclipse.rcp.ui.icons/icons/16x16/chromatogram.gif";
    public static final String TOOLTIP = "Chromatogram - Detector Type: WSD";
    private static final Logger logger = Logger.getLogger(ChromatogramEditorWSD.class);
    @Inject
    private MPart part;
    @Inject
    private MDirtyable dirtyable;
    @Inject
    private IEventBroker eventBroker;
    private EventHandler eventHandler;
    @Inject
    private MApplication application;
    @Inject
    private EModelService modelService;
    @Inject
    private EPartService partService;
    private DecimalFormat decimalFormat = ValueFormat.getDecimalFormatEnglish((String)"0.0##");
    private File chromatogramFile;
    private ChromatogramSelectionWSD chromatogramSelection;
    private EditorChromatogramUI chromatogramUI;
    private MarkedWavelengthsChooser selectedWavelengthChooser;
    private int chromatogramPageIndex;
    private int optionsPageIndex;
    private int infoPageIndex;
    private int referencedChromatogramPageIndex;
    private TabFolder tabFolder;
    private Button buttonOverlay;
    private CLabel infoStartRetentionTimeLabel;
    private CLabel infoStopRetentionTimeLabel;
    private Button buttonLockOffset;
    private FormToolkit formToolkit;

    @PostConstruct
    private void createControl(Composite parent) {
        this.subscribe();
        this.loadChromatogram();
        this.createPages(parent);
        if (this.chromatogramSelection != null) {
            this.chromatogramSelection.update(true);
        }
    }

    @Focus
    public void setFocus() {
        if (this.tabFolder != null) {
            this.tabFolder.setFocus();
            if (this.tabFolder.getSelectionIndex() == this.chromatogramPageIndex && this.chromatogramSelection != null) {
                this.chromatogramSelection.update(false);
            }
        }
    }

    @PreDestroy
    private void preDestroy() {
        this.unsubscribe();
        ChromatogramSelectionWSDUpdateNotifier.fireUpdateChange(null, (boolean)true);
        if (this.chromatogramSelection != null) {
            this.chromatogramSelection.dispose();
        }
        if (this.modelService != null) {
            MPartStack partStack = (MPartStack)this.modelService.find("org.eclipse.e4.primaryDataStack", (MUIElement)this.application);
            this.part.setToBeRendered(false);
            this.part.setVisible(false);
            partStack.getChildren().remove(this.part);
        }
        if (this.formToolkit != null) {
            this.formToolkit.dispose();
        }
        System.gc();
    }

    @Persist
    public void save() {
        final Shell shell = Display.getDefault().getActiveShell();
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(shell);
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    monitor.beginTask("Save Chromatogram", -1);
                    try {
                        ChromatogramEditorWSD.this.saveChromatogram(monitor, shell);
                    }
                    catch (NoChromatogramConverterAvailableException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            dialog.run(true, false, runnable);
        }
        catch (InvocationTargetException invocationTargetException) {
            this.saveAs();
        }
        catch (InterruptedException e) {
            logger.warn((Object)e);
        }
    }

    private void saveChromatogram(IProgressMonitor monitor, Shell shell) throws NoChromatogramConverterAvailableException {
        if (this.chromatogramSelection != null && shell != null) {
            IChromatogramWSD chromatogram = this.chromatogramSelection.getChromatogramWSD();
            String converterId = chromatogram.getConverterId();
            if (converterId != null && !converterId.equals("") && this.chromatogramFile != null) {
                monitor.subTask("Save Chromatogram");
                IChromatogramExportConverterProcessingInfo processingInfo = ChromatogramConverterWSD.convert((File)this.chromatogramFile, (IChromatogramWSD)chromatogram, (String)converterId, (IProgressMonitor)monitor);
                try {
                    processingInfo.getFile();
                    this.dirtyable.setDirty(false);
                }
                catch (TypeCastException typeCastException) {
                    throw new NoChromatogramConverterAvailableException();
                }
            } else {
                throw new NoChromatogramConverterAvailableException();
            }
        }
    }

    public boolean saveAs() {
        boolean saveSuccessful = false;
        if (this.chromatogramSelection != null) {
            try {
                saveSuccessful = ChromatogramFileSupport.saveChromatogram(this.chromatogramSelection.getChromatogramWSD());
                this.dirtyable.setDirty(!saveSuccessful);
            }
            catch (NoConverterAvailableException e) {
                logger.warn((Object)e);
            }
        }
        return saveSuccessful;
    }

    @Override
    public IChromatogramSelectionWSD getChromatogramSelection() {
        return this.chromatogramSelection;
    }

    public void update(IChromatogramSelectionWSD chromatogramSelection, boolean forceReload) {
        if (this.fireUpdate(chromatogramSelection, forceReload)) {
            int selectionIndex;
            if (forceReload) {
                this.dirtyable.setDirty(true);
            }
            if ((selectionIndex = this.tabFolder.getSelectionIndex()) == this.optionsPageIndex) {
                this.updateOptionsPageValues();
            } else if (selectionIndex == this.infoPageIndex) {
                this.updateInfoPageValues();
            }
            this.chromatogramUI.update(chromatogramSelection, forceReload);
        }
    }

    private void subscribe() {
        if (this.eventBroker != null) {
            this.eventHandler = new EventHandler(){

                public void handleEvent(Event event) {
                    IChromatogramSelectionWSD selection = (IChromatogramSelectionWSD)event.getProperty("ChromatogramSelection");
                    boolean forceReload = (Boolean)event.getProperty("ForceReload");
                    ChromatogramEditorWSD.this.update(selection, forceReload);
                }
            };
            this.eventBroker.subscribe("chromatogram/wsd/update/chromatogramselection", this.eventHandler);
        }
    }

    private void unsubscribe() {
        if (this.eventBroker != null && this.eventHandler != null) {
            this.eventBroker.unsubscribe(this.eventHandler);
        }
    }

    private void loadChromatogram() {
        try {
            Object object = this.part.getObject();
            if (object instanceof String) {
                File file = new File((String)object);
                this.importChromatogram(file);
            } else if (object instanceof IChromatogramWSD) {
                IChromatogramWSD chromatogram = (IChromatogramWSD)object;
                this.chromatogramSelection = new ChromatogramSelectionWSD((IChromatogram)chromatogram);
                this.chromatogramFile = null;
            }
        }
        catch (Exception e) {
            logger.warn((Object)e);
        }
    }

    private void importChromatogram(File file) throws FileNotFoundException, NoChromatogramConverterAvailableException, FileIsNotReadableException, FileIsEmptyException, ChromatogramIsNullException {
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(Display.getCurrent().getActiveShell());
        ChromatogramImportRunnable runnable = new ChromatogramImportRunnable(file, this.chromatogramSelection);
        try {
            dialog.run(true, false, (IRunnableWithProgress)runnable);
        }
        catch (InvocationTargetException e) {
            logger.warn((Object)e);
        }
        catch (InterruptedException e) {
            logger.warn((Object)e);
        }
        this.chromatogramSelection = runnable.getChromatogramSelection();
        this.chromatogramFile = file;
        int sizeReferencedChromatograms = this.chromatogramSelection.getChromatogramWSD().getReferencedChromatograms().size();
        if (sizeReferencedChromatograms > 0) {
            ReferencedChromatogramDialog referencedChromatogramDialog = new ReferencedChromatogramDialog(Display.getCurrent().getActiveShell(), this.chromatogramSelection.getChromatogram());
            referencedChromatogramDialog.create();
            if (referencedChromatogramDialog.open() == 0) {
                List selectedChromatograms = referencedChromatogramDialog.getSelectedChromatograms();
                for (IChromatogram chromatogram : selectedChromatograms) {
                    ChromatogramSupport.getInstanceEditorSupport().openEditor(chromatogram, this.modelService, this.application, this.partService);
                }
            }
        }
    }

    private void createPages(Composite parent) {
        if (this.chromatogramSelection != null && this.chromatogramSelection.getChromatogramWSD() != null) {
            this.part.setLabel(this.chromatogramSelection.getChromatogramWSD().getName());
            this.tabFolder = new TabFolder(parent, 1024);
            this.createChromatogramPage();
            this.chromatogramPageIndex = 0;
            this.createOptionsPage();
            this.optionsPageIndex = 1;
            this.createInfoPage();
            this.infoPageIndex = 2;
            this.createReferencedChromatogramPage();
            this.referencedChromatogramPageIndex = 3;
            this.tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    int index = ChromatogramEditorWSD.this.tabFolder.getSelectionIndex();
                    if (ChromatogramEditorWSD.this.chromatogramSelection != null) {
                        switch (index) {
                            case 0: {
                                ChromatogramEditorWSD.this.update((IChromatogramSelectionWSD)ChromatogramEditorWSD.this.chromatogramSelection, false);
                                break;
                            }
                            case 1: {
                                ChromatogramEditorWSD.this.updateOptionsPageValues();
                                break;
                            }
                            case 2: {
                                ChromatogramEditorWSD.this.updateInfoPageValues();
                                break;
                            }
                        }
                    }
                }
            });
        } else {
            this.createErrorMessagePage(parent);
        }
    }

    private void updateOptionsPageValues() {
        if (this.selectedWavelengthChooser != null) {
            this.selectedWavelengthChooser.setMarkedWavelengths(this.chromatogramSelection.getSelectedWavelengths());
        }
    }

    private void updateInfoPageValues() {
        if (this.buttonOverlay != null) {
            this.buttonOverlay.setSelection(this.chromatogramSelection.isOverlaySelected());
        }
        if (this.infoStartRetentionTimeLabel != null && this.infoStopRetentionTimeLabel != null) {
            this.infoStartRetentionTimeLabel.setText("Start Retention Time (Minutes): " + this.decimalFormat.format((double)this.chromatogramSelection.getStartRetentionTime() / 60000.0));
            this.infoStopRetentionTimeLabel.setText("Stop Retention Time (Minutes): " + this.decimalFormat.format((double)this.chromatogramSelection.getStopRetentionTime() / 60000.0));
        }
        if (this.buttonLockOffset != null) {
            this.buttonLockOffset.setSelection(this.chromatogramSelection.isLockOffset());
        }
    }

    private void createChromatogramPage() {
        TabItem tabItem = new TabItem(this.tabFolder, 0);
        tabItem.setText("Chromatogram");
        this.chromatogramUI = new EditorChromatogramUI((Composite)this.tabFolder, 0);
        this.chromatogramUI.setMaster(true);
        this.chromatogramUI.update((IChromatogramSelectionWSD)this.chromatogramSelection, true);
        tabItem.setControl((Control)this.chromatogramUI);
    }

    private void createErrorMessagePage(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new FillLayout());
        this.formToolkit = new FormToolkit(composite.getDisplay());
        ScrolledForm scrolledForm = this.formToolkit.createScrolledForm(composite);
        Composite scrolledFormComposite = scrolledForm.getBody();
        this.formToolkit.decorateFormHeading(scrolledForm.getForm());
        scrolledFormComposite.setLayout((Layout)new TableWrapLayout());
        scrolledForm.setText("Chromatogram Editor");
        this.createProblemSection(scrolledFormComposite);
        this.createResolutionSection(scrolledFormComposite);
    }

    private void createProblemSection(Composite parent) {
        Section section = this.formToolkit.createSection(parent, 384);
        section.setText("Problem");
        section.setDescription("There has gone something wrong to open the chromatogram.");
        section.marginWidth = 5;
        section.marginHeight = 5;
        section.setLayoutData((Object)new TableWrapData(256));
        Composite client = this.formToolkit.createComposite((Composite)section, 64);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        client.setLayout((Layout)layout);
        this.createLabel(client, "The chromatogram couldn't be loaded.", "warn.gif");
        this.createLabel(client, "Does the selected chromatogram contains data recorded by a flame ionization detector?", "question.gif");
        this.createLabel(client, "Is the data file corrupted?", "question.gif");
        this.createLabel(client, "Is an appropriate file format converter installed?", "question.gif");
        this.createLink(client, "Converters can be installed using the marketplace.", "https://marketplace.openchrom.net");
        this.createLabel(client, "Does the converter has a valid license? (Menu -> Window -> Preferences -> Converter)", "question.gif");
        this.createLink(client, "Create a log-in and retrieve free serial keys.", "https://marketplace.openchrom.net");
        section.setClient((Control)client);
        this.formToolkit.paintBordersFor(client);
    }

    private void createResolutionSection(Composite parent) {
        Section section = this.formToolkit.createSection(parent, 384);
        section.setText("Further Questions");
        section.setDescription("The developers may have a solution for you.");
        section.marginWidth = 5;
        section.marginHeight = 5;
        section.setLayoutData((Object)new TableWrapData(256));
        Composite client = this.formToolkit.createComposite((Composite)section, 64);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        client.setLayout((Layout)layout);
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        this.createLabel(client, "MSD data is also supported.", "info.gif");
        this.createLink(client, "Please contact the developers, if you have further questions.", "https://www.openchrom.net");
        section.setClient((Control)client);
        this.formToolkit.paintBordersFor(client);
    }

    private CLabel createLabel(Composite parent, String text, String image) {
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        CLabel label = new CLabel(parent, 16384);
        label.setText(text);
        if (image != null) {
            label.setImage(ApplicationImageFactory.getInstance().getImage(image, "16x16"));
        }
        label.setLayoutData((Object)gridData);
        return label;
    }

    private void createReferencedChromatogramHyperlink(Composite parent, int number, final IChromatogramWSD chromatogram) {
        ImageHyperlink imageHyperlink = new ImageHyperlink(parent, 16384);
        imageHyperlink.setImage(ApplicationImageFactory.getInstance().getImage("execute.gif", "16x16"));
        imageHyperlink.setText("Chromatogram #" + number);
        imageHyperlink.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
                ChromatogramSupport.getInstanceEditorSupport().openOverview((IChromatogramOverview)chromatogram, ChromatogramEditorWSD.this.eventBroker);
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
                ChromatogramSupport.getInstanceEditorSupport().openEditor((IChromatogram)chromatogram, ChromatogramEditorWSD.this.modelService, ChromatogramEditorWSD.this.application, ChromatogramEditorWSD.this.partService);
            }
        });
    }

    private void createLink(Composite parent, String text, final String url) {
        Link link = new Link(parent, 0);
        link.setText(String.valueOf(text) + " (<a>" + url + "</a>)");
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                Program.launch((String)url);
            }
        });
    }

    private void createOptionsPage() {
        TabItem tabItem = new TabItem(this.tabFolder, 0);
        tabItem.setText("Options");
        Composite composite = new Composite((Composite)this.tabFolder, 0);
        composite.setLayout((Layout)new FillLayout());
        this.formToolkit = new FormToolkit(composite.getDisplay());
        ScrolledForm scrolledForm = this.formToolkit.createScrolledForm(composite);
        Composite scrolledFormComposite = scrolledForm.getBody();
        this.formToolkit.decorateFormHeading(scrolledForm.getForm());
        scrolledFormComposite.setLayout((Layout)new TableWrapLayout());
        scrolledForm.setText("Chromatogram Options");
        this.createOptionsPageSection(scrolledFormComposite);
        tabItem.setControl((Control)composite);
    }

    private void createInfoPage() {
        TabItem tabItem = new TabItem(this.tabFolder, 0);
        tabItem.setText("Info");
        Composite composite = new Composite((Composite)this.tabFolder, 0);
        composite.setLayout((Layout)new FillLayout());
        this.formToolkit = new FormToolkit(composite.getDisplay());
        ScrolledForm scrolledForm = this.formToolkit.createScrolledForm(composite);
        Composite scrolledFormComposite = scrolledForm.getBody();
        this.formToolkit.decorateFormHeading(scrolledForm.getForm());
        scrolledFormComposite.setLayout((Layout)new TableWrapLayout());
        scrolledForm.setText("Chromatogram Info");
        this.createInfoPageSection(scrolledFormComposite);
        tabItem.setControl((Control)composite);
    }

    private void createOptionsPageSection(Composite parent) {
        Section section = this.formToolkit.createSection(parent, 384);
        section.setText("Options");
        section.setDescription("This page shows several additional chromatogram options.");
        section.marginWidth = 5;
        section.marginHeight = 5;
        section.setLayoutData((Object)new TableWrapData(256));
        Composite client = this.formToolkit.createComposite((Composite)section, 64);
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        client.setLayout((Layout)layout);
        this.createLabel(client, "Use the selected wavelengths to inspect the chromatogram using different views.", "info.gif");
        Composite compositeIons = new Composite(client, 0);
        compositeIons.setLayout((Layout)new GridLayout(1, true));
        compositeIons.setLayoutData((Object)new GridData(1808));
        this.selectedWavelengthChooser = new MarkedWavelengthsChooser(compositeIons, 0);
        this.selectedWavelengthChooser.setMarkedWavelengths(this.chromatogramSelection.getSelectedWavelengths());
        this.selectedWavelengthChooser.setLabelText("Add/Remove selected wavelengths");
        section.setClient((Control)client);
        this.formToolkit.paintBordersFor(client);
    }

    private void createInfoPageSection(Composite parent) {
        Section section = this.formToolkit.createSection(parent, 384);
        section.setText("Chromatogram Selection");
        section.setDescription("Display of the current chromatogram selection.");
        section.marginWidth = 5;
        section.marginHeight = 5;
        section.setLayoutData((Object)new TableWrapData(256));
        Composite client = this.formToolkit.createComposite((Composite)section, 64);
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        client.setLayout((Layout)layout);
        this.buttonOverlay = new Button(client, 32);
        this.buttonOverlay.setSelection(this.chromatogramSelection.isOverlaySelected());
        this.buttonOverlay.setText("Show chromatogram in overlay");
        this.buttonOverlay.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean overlaySelected = ChromatogramEditorWSD.this.buttonOverlay.getSelection();
                ChromatogramEditorWSD.this.chromatogramSelection.setOverlaySelected(overlaySelected);
            }
        });
        this.infoStartRetentionTimeLabel = this.createLabel(client, "", "info.gif");
        this.infoStopRetentionTimeLabel = this.createLabel(client, "", "info.gif");
        this.buttonLockOffset = new Button(client, 32);
        this.buttonLockOffset.setSelection(this.chromatogramSelection.isLockOffset());
        this.buttonLockOffset.setText("Lock Offset");
        this.buttonLockOffset.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean lockOffset = ChromatogramEditorWSD.this.buttonLockOffset.getSelection();
                ChromatogramEditorWSD.this.chromatogramSelection.setLockOffset(lockOffset);
            }
        });
        section.setClient((Control)client);
        this.formToolkit.paintBordersFor(client);
    }

    private void createReferencedChromatogramPage() {
        TabItem tabItem = new TabItem(this.tabFolder, 0);
        tabItem.setText("Referenced Chromatograms");
        Composite composite = new Composite((Composite)this.tabFolder, 0);
        composite.setLayout((Layout)new FillLayout());
        this.formToolkit = new FormToolkit(composite.getDisplay());
        ScrolledForm scrolledForm = this.formToolkit.createScrolledForm(composite);
        Composite scrolledFormComposite = scrolledForm.getBody();
        this.formToolkit.decorateFormHeading(scrolledForm.getForm());
        scrolledFormComposite.setLayout((Layout)new TableWrapLayout());
        scrolledForm.setText("Chromatograms");
        this.createReferencedChromatogramPageSection(scrolledFormComposite);
        tabItem.setControl((Control)composite);
    }

    private void createReferencedChromatogramPageSection(Composite parent) {
        Section section = this.formToolkit.createSection(parent, 384);
        section.setText("References");
        section.setDescription("Display of the chromatogram references.");
        section.marginWidth = 5;
        section.marginHeight = 5;
        section.setLayoutData((Object)new TableWrapData(256));
        Composite client = this.formToolkit.createComposite((Composite)section, 64);
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        client.setLayout((Layout)layout);
        List references = this.chromatogramSelection.getChromatogram().getReferencedChromatograms();
        int counter = 1;
        for (IChromatogram chromatogram : references) {
            if (!(chromatogram instanceof IChromatogramWSD)) continue;
            IChromatogramWSD chromatogramWSD = (IChromatogramWSD)chromatogram;
            this.createReferencedChromatogramHyperlink(client, counter++, chromatogramWSD);
        }
        section.setClient((Control)client);
        this.formToolkit.paintBordersFor(client);
    }

    private boolean fireUpdate(IChromatogramSelectionWSD chromatogramSelection, boolean forceReload) {
        if (this.chromatogramUI == null || chromatogramSelection == null || this.chromatogramSelection == null) {
            return false;
        }
        if (forceReload) {
            return this.chromatogramSelection.getChromatogramWSD() == chromatogramSelection.getChromatogramWSD();
        }
        return this.chromatogramSelection == chromatogramSelection;
    }
}

