/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.internal.provider;

import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Composite;

public class OverlaySettingsCheckBoxEditingSupport
extends EditingSupport {
    private CheckboxCellEditor cellEditor;
    private String type;

    public OverlaySettingsCheckBoxEditingSupport(TableViewer tableViewer, String type) {
        super((ColumnViewer)tableViewer);
        this.type = type;
        this.cellEditor = new CheckboxCellEditor((Composite)tableViewer.getTable());
    }

    protected CellEditor getCellEditor(Object element) {
        return this.cellEditor;
    }

    protected boolean canEdit(Object element) {
        return true;
    }

    protected Object getValue(Object element) {
        if (element instanceof IChromatogramSelection) {
            IChromatogramSelection chromatogramSelection = (IChromatogramSelection)element;
            if (this.type.equals("Overlay")) {
                return chromatogramSelection.isOverlaySelected();
            }
            if (this.type.equals("Lock Offset")) {
                return chromatogramSelection.isLockOffset();
            }
        }
        return false;
    }

    protected void setValue(Object element, Object value) {
        if (element instanceof IChromatogramSelection) {
            IChromatogramSelection chromatogramSelection = (IChromatogramSelection)element;
            if (this.type.equals("Overlay")) {
                chromatogramSelection.setOverlaySelected(((Boolean)value).booleanValue());
            } else if (this.type.equals("Lock Offset")) {
                chromatogramSelection.setLockOffset(((Boolean)value).booleanValue());
            }
            chromatogramSelection.fireUpdateChange(false);
        }
    }
}

