/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.integrator.supplier.trapezoid.ui.internal.handler;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.core.chromatogram.ChromatogramIntegrator;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.core.settings.chromatogram.ChromatogramIntegrationSettings;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.core.settings.chromatogram.IChromatogramIntegrationSettings;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.processing.IChromatogramIntegratorProcessingInfo;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.result.IChromatogramIntegrationResults;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.ui.notifier.IntegrationResultUpdateNotifier;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.core.exceptions.TypeCastException;
import org.eclipse.chemclipse.processing.ui.support.ProcessingInfoViewSupport;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class ChromatogramIntegratorRunnable
implements IRunnableWithProgress {
    private static final Logger logger = Logger.getLogger(ChromatogramIntegratorRunnable.class);
    private static final String CHROMATOGRAM_INTEGRATOR_ID = "org.eclipse.chemclipse.chromatogram.xxd.integrator.supplier.trapezoid.chromatogramIntegrator";
    private IChromatogramSelection chromatogramSelection;

    public ChromatogramIntegratorRunnable(IChromatogramSelection chromatogramSelection) {
        this.chromatogramSelection = chromatogramSelection;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            monitor.beginTask("Integrator Trapezoid", -1);
            ChromatogramIntegrationSettings chromatogramIntegrationSettings = new ChromatogramIntegrationSettings();
            IChromatogramIntegratorProcessingInfo processingInfo = ChromatogramIntegrator.integrate((IChromatogramSelection)this.chromatogramSelection, (IChromatogramIntegrationSettings)chromatogramIntegrationSettings, (String)CHROMATOGRAM_INTEGRATOR_ID, (IProgressMonitor)monitor);
            ProcessingInfoViewSupport.updateProcessingInfo((IProcessingInfo)processingInfo, (boolean)false);
            try {
                IChromatogramIntegrationResults chromatogramIntegrationResults = processingInfo.getChromatogramIntegrationResults();
                IntegrationResultUpdateNotifier.fireUpdateChange((IChromatogramIntegrationResults)chromatogramIntegrationResults);
            }
            catch (TypeCastException e) {
                logger.warn((Object)e);
            }
        }
        finally {
            monitor.done();
        }
    }
}

