/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.process.supplier.batchprocess.ui.internal.wizards;

import org.eclipse.chemclipse.chromatogram.msd.process.model.ChromatogramProcessEntry;
import org.eclipse.chemclipse.chromatogram.msd.process.model.IChromatogramProcessEntry;
import org.eclipse.chemclipse.chromatogram.msd.process.support.ProcessTypeSupport;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ChromatogramProcessEntriesWizardPage
extends WizardPage {
    private ProcessTypeSupport processTypeSupport;
    private IChromatogramProcessEntry chromatogramProcessEntry;
    private Combo processorComboBox;
    private Combo pluginComboBox;
    private String[] processorCategories;
    private String[] selectedPluginIds;
    private String[] selectedPluginNames;

    protected ChromatogramProcessEntriesWizardPage(String pageName, IChromatogramProcessEntry chromatogramProcessEntry) {
        super(pageName);
        this.setTitle("Chromatogram Process Entries");
        this.setDescription("This wizard lets you select several chromatogram filter, integrators, identifier ...");
        this.processTypeSupport = new ProcessTypeSupport();
        this.processorCategories = this.processTypeSupport.getProcessorCategories();
        this.chromatogramProcessEntry = chromatogramProcessEntry;
    }

    public IChromatogramProcessEntry getChromatogramProcessEntry() {
        int pluginSelection;
        ChromatogramProcessEntry newProcessEntry = null;
        int typeSelection = this.processorComboBox.getSelectionIndex();
        if (typeSelection >= 0 && (pluginSelection = this.pluginComboBox.getSelectionIndex()) >= 0) {
            String processCategory = this.processorCategories[this.processorComboBox.getSelectionIndex()];
            String processorId = this.selectedPluginIds[pluginSelection];
            if (!processorId.equals("n.a.")) {
                if (this.chromatogramProcessEntry == null) {
                    newProcessEntry = new ChromatogramProcessEntry(processCategory, processorId);
                } else {
                    this.chromatogramProcessEntry.setProcessorId(processorId);
                    this.chromatogramProcessEntry.setProcessCategory(processCategory);
                    newProcessEntry = this.chromatogramProcessEntry;
                }
            }
        }
        return newProcessEntry;
    }

    public void createControl(Composite parent) {
        String processCategory;
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        composite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(768);
        gridData.heightHint = 30;
        Label label = new Label(composite, 0);
        label.setText("Select the processing category:");
        label.setLayoutData((Object)gridData);
        this.processorComboBox = new Combo(composite, 0);
        this.processorComboBox.setItems(this.processorCategories);
        this.processorComboBox.setLayoutData((Object)gridData);
        this.processorComboBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                String processorCategory = ChromatogramProcessEntriesWizardPage.this.processorCategories[ChromatogramProcessEntriesWizardPage.this.processorComboBox.getSelectionIndex()];
                ChromatogramProcessEntriesWizardPage.this.selectedPluginIds = ChromatogramProcessEntriesWizardPage.this.processTypeSupport.getPluginIds(processorCategory);
                ChromatogramProcessEntriesWizardPage.this.selectedPluginNames = ChromatogramProcessEntriesWizardPage.this.processTypeSupport.getProcessorNames(processorCategory, ChromatogramProcessEntriesWizardPage.this.selectedPluginIds);
                ChromatogramProcessEntriesWizardPage.this.pluginComboBox.setItems(ChromatogramProcessEntriesWizardPage.this.selectedPluginNames);
            }
        });
        if (this.chromatogramProcessEntry != null) {
            processCategory = this.chromatogramProcessEntry.getProcessCategory();
            int index = this.getProcessorTypeIndex(processCategory);
            this.processorComboBox.select(index);
        }
        label = new Label(composite, 0);
        label.setText("Select plug-in:");
        label.setLayoutData((Object)gridData);
        this.pluginComboBox = new Combo(composite, 0);
        this.pluginComboBox.setLayoutData((Object)gridData);
        if (this.chromatogramProcessEntry != null) {
            processCategory = this.chromatogramProcessEntry.getProcessCategory();
            this.selectedPluginIds = this.processTypeSupport.getPluginIds(processCategory);
            this.selectedPluginNames = this.processTypeSupport.getProcessorNames(processCategory, this.selectedPluginIds);
            this.pluginComboBox.setItems(this.selectedPluginNames);
            String processorId = this.chromatogramProcessEntry.getProcessorId();
            int index = this.getProcessorIdIndex(processorId);
            this.pluginComboBox.select(index);
        }
        this.setControl((Control)composite);
    }

    private int getProcessorTypeIndex(String processCategory) {
        int result = -1;
        int index = 0;
        while (index < this.processorCategories.length) {
            if (this.processorCategories[index].equals(processCategory)) {
                result = index;
            }
            ++index;
        }
        return result;
    }

    private int getProcessorIdIndex(String processorId) {
        int result = -1;
        int index = 0;
        while (index < this.selectedPluginIds.length) {
            if (this.selectedPluginIds[index].equals(processorId)) {
                result = index;
            }
            ++index;
        }
        return result;
    }
}

