/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.process.supplier.batchprocess.ui.editors;

import java.util.List;
import org.eclipse.chemclipse.chromatogram.msd.process.model.IChromatogramProcessEntry;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.batchprocess.model.IBatchProcessJob;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.batchprocess.ui.editors.BatchProcessJobEditor;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.batchprocess.ui.editors.IMultiEditorPage;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.batchprocess.ui.internal.wizards.BatchProcessWizardDialog;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.batchprocess.ui.internal.wizards.ChromatogramProcessEntriesWizard;
import org.eclipse.chemclipse.chromatogram.msd.process.support.ProcessTypeSupport;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class ProcessEntriesPage
implements IMultiEditorPage {
    private FormToolkit toolkit;
    private int pageIndex;
    private IBatchProcessJob batchProcessJob;
    private Table processEntriesTable;

    public ProcessEntriesPage(BatchProcessJobEditor editorPart, Composite container) {
        this.createPage(editorPart, container);
    }

    @Override
    public int getPageIndex() {
        return this.pageIndex;
    }

    @Override
    public void dispose() {
        if (this.toolkit != null) {
            this.toolkit.dispose();
        }
    }

    @Override
    public void setBatchProcessJob(IBatchProcessJob batchProcessJob) {
        if (batchProcessJob != null) {
            this.batchProcessJob = batchProcessJob;
            this.reloadTable();
        }
    }

    private void createPage(BatchProcessJobEditor editorPart, Composite container) {
        Composite parent = new Composite(container, 0);
        parent.setLayout((Layout)new FillLayout());
        parent.setBackground(Display.getCurrent().getSystemColor(1));
        this.toolkit = new FormToolkit(parent.getDisplay());
        ScrolledForm scrolledForm = this.toolkit.createScrolledForm(parent);
        Composite scrolledFormComposite = scrolledForm.getBody();
        scrolledFormComposite.setLayout((Layout)new TableWrapLayout());
        scrolledForm.setText("Process Entry Editor");
        this.createProcessEntriesSection(scrolledFormComposite, editorPart);
        this.pageIndex = editorPart.addPage((Control)parent);
    }

    private void createProcessEntriesSection(Composite parent, BatchProcessJobEditor editorPart) {
        Section section = this.toolkit.createSection(parent, 384);
        section.setText("Process entries");
        section.setDescription("Select the process entries. Use the add, remove, move up and down buttons.");
        section.marginWidth = 5;
        section.marginHeight = 5;
        section.setLayoutData((Object)new TableWrapData(256));
        Composite client = this.toolkit.createComposite((Composite)section, 64);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        client.setLayout((Layout)layout);
        this.createTable(client);
        this.createButtons(client, editorPart);
        section.setClient((Control)client);
        this.toolkit.paintBordersFor(client);
    }

    private void createTable(Composite client) {
        this.processEntriesTable = this.toolkit.createTable(client, 2);
        GridData gridData = new GridData(1808);
        gridData.heightHint = 300;
        gridData.widthHint = 100;
        gridData.verticalSpan = 5;
        this.processEntriesTable.setLayoutData((Object)gridData);
        this.processEntriesTable.setHeaderVisible(true);
        this.processEntriesTable.setLinesVisible(true);
    }

    private void createButtons(Composite client, BatchProcessJobEditor editorPart) {
        this.createAddButton(client, editorPart);
        this.createRemoveButton(client, editorPart);
        this.createEditButton(client, editorPart);
        this.createMoveUpButton(client, editorPart);
        this.createMoveDownButton(client, editorPart);
    }

    private void createAddButton(Composite client, final BatchProcessJobEditor editorPart) {
        Button add = this.toolkit.createButton(client, "Add", 8);
        add.setLayoutData((Object)new GridData(258));
        add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                Shell shell = Display.getCurrent().getActiveShell();
                ChromatogramProcessEntriesWizard processEntriesWizard = new ChromatogramProcessEntriesWizard(null);
                BatchProcessWizardDialog wizardDialog = new BatchProcessWizardDialog(shell, (IWizard)processEntriesWizard);
                wizardDialog.create();
                int returnCode = wizardDialog.open();
                if (returnCode == 0) {
                    IChromatogramProcessEntry processEntry = processEntriesWizard.getChromatogramProcessEntry();
                    if (processEntry != null) {
                        List processEntries = ProcessEntriesPage.this.batchProcessJob.getChromatogramProcessEntries();
                        processEntries.add(processEntry);
                        ProcessEntriesPage.this.reloadTable();
                        editorPart.setDirty();
                    } else {
                        MessageBox messageBox = new MessageBox(shell);
                        messageBox.setText("Error Add Process Entry");
                        messageBox.setMessage("Please select a valid processing type and a valid plug-in.");
                        messageBox.open();
                    }
                }
            }
        });
    }

    private void createRemoveButton(Composite client, final BatchProcessJobEditor editorPart) {
        Button remove = this.toolkit.createButton(client, "Remove", 8);
        remove.setLayoutData((Object)new GridData(258));
        remove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                ProcessEntriesPage.this.removeEntries(ProcessEntriesPage.this.processEntriesTable.getSelectionIndices());
                editorPart.setDirty();
            }
        });
    }

    private void createEditButton(Composite client, final BatchProcessJobEditor editorPart) {
        Button edit = this.toolkit.createButton(client, "Edit", 8);
        edit.setLayoutData((Object)new GridData(258));
        edit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                Shell shell = Display.getCurrent().getActiveShell();
                List processEntries = ProcessEntriesPage.this.batchProcessJob.getChromatogramProcessEntries();
                IChromatogramProcessEntry entry = (IChromatogramProcessEntry)processEntries.get(ProcessEntriesPage.this.processEntriesTable.getSelectionIndex());
                ChromatogramProcessEntriesWizard processEntriesWizard = new ChromatogramProcessEntriesWizard(entry);
                BatchProcessWizardDialog wizardDialog = new BatchProcessWizardDialog(shell, (IWizard)processEntriesWizard);
                wizardDialog.create();
                int returnCode = wizardDialog.open();
                if (returnCode == 0) {
                    IChromatogramProcessEntry processEntry = processEntriesWizard.getChromatogramProcessEntry();
                    if (processEntry != null) {
                        ProcessEntriesPage.this.reloadTable();
                        editorPart.setDirty();
                    }
                } else {
                    MessageBox messageBox = new MessageBox(shell);
                    messageBox.setText("Error Add Process Entry");
                    messageBox.setMessage("Please select a valid processing type and a valid plug-in.");
                    messageBox.open();
                }
            }
        });
    }

    private void createMoveUpButton(Composite client, final BatchProcessJobEditor editorPart) {
        Button up = this.toolkit.createButton(client, "Move Up", 8);
        up.setLayoutData((Object)new GridData(258));
        up.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                ProcessEntriesPage.this.moveUp(ProcessEntriesPage.this.processEntriesTable.getSelectionIndex());
                editorPart.setDirty();
            }
        });
    }

    private void createMoveDownButton(Composite client, final BatchProcessJobEditor editorPart) {
        Button down = this.toolkit.createButton(client, "Move Down", 8);
        down.setLayoutData((Object)new GridData(258));
        down.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                ProcessEntriesPage.this.moveDown(ProcessEntriesPage.this.processEntriesTable.getSelectionIndex());
                editorPart.setDirty();
            }
        });
    }

    private void moveUp(int index) {
        List processEntries = this.batchProcessJob.getChromatogramProcessEntries();
        if (index > 0) {
            int indexUp = index - 1;
            IChromatogramProcessEntry entry1 = (IChromatogramProcessEntry)processEntries.get(indexUp);
            IChromatogramProcessEntry entry2 = (IChromatogramProcessEntry)processEntries.get(index);
            processEntries.set(indexUp, entry2);
            processEntries.set(index, entry1);
        }
        this.reloadTable();
    }

    private void moveDown(int index) {
        List processEntries = this.batchProcessJob.getChromatogramProcessEntries();
        if (index < processEntries.size() - 1) {
            int indexDown = index + 1;
            IChromatogramProcessEntry entry1 = (IChromatogramProcessEntry)processEntries.get(index);
            IChromatogramProcessEntry entry2 = (IChromatogramProcessEntry)processEntries.get(indexDown);
            processEntries.set(indexDown, entry1);
            processEntries.set(index, entry2);
        }
        this.reloadTable();
    }

    private void removeEntries(int[] indices) {
        if (indices == null || indices.length == 0) {
            return;
        }
        this.processEntriesTable.remove(indices);
        List processEntries = this.batchProcessJob.getChromatogramProcessEntries();
        int counter = 0;
        int[] nArray = indices;
        int n = indices.length;
        int n2 = 0;
        while (n2 < n) {
            int index = nArray[n2];
            processEntries.remove(index -= counter);
            ++counter;
            ++n2;
        }
    }

    private void reloadTable() {
        if (this.batchProcessJob != null && this.processEntriesTable != null) {
            this.processEntriesTable.removeAll();
            String[] titles = new String[]{"Name", "Type", "Processor Id"};
            int i = 0;
            while (i < titles.length) {
                TableColumn column = new TableColumn(this.processEntriesTable, 0);
                column.setText(titles[i]);
                ++i;
            }
            ProcessTypeSupport processTypeSupport = new ProcessTypeSupport();
            List processEntries = this.batchProcessJob.getChromatogramProcessEntries();
            for (IChromatogramProcessEntry entry : processEntries) {
                TableItem item = new TableItem(this.processEntriesTable, 0);
                item.setText(0, processTypeSupport.getProcessorName(entry));
                item.setText(1, entry.getProcessCategory());
                item.setText(2, entry.getProcessorId());
            }
            int i2 = 0;
            while (i2 < titles.length) {
                this.processEntriesTable.getColumn(i2).pack();
                ++i2;
            }
        }
    }
}

