/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.support.util;

import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.chemclipse.logging.core.Logger;

public class IonListUtil {
    private static final Logger logger = Logger.getLogger(IonListUtil.class);

    public String createList(String[] items) {
        Set<String> ionSet = this.getIonSet(items);
        String ions = "";
        for (String ion : ionSet) {
            ions = ions.concat(String.valueOf(ion) + ";");
        }
        return ions;
    }

    public String[] parseString(String stringList) {
        String[] decodedArray;
        if (stringList.contains(";")) {
            StringTokenizer stringTokenizer = new StringTokenizer(stringList, ";");
            int arraySize = stringTokenizer.countTokens();
            decodedArray = new String[arraySize];
            int i = 0;
            while (i < arraySize) {
                decodedArray[i] = stringTokenizer.nextToken(";");
                ++i;
            }
        } else {
            decodedArray = new String[]{};
        }
        return decodedArray;
    }

    public Set<Integer> getIons(String preferenceEntry) {
        String[] items;
        HashSet<Integer> ions = new HashSet<Integer>();
        if (preferenceEntry != "" && (items = this.parseString(preferenceEntry)).length > 0) {
            String[] stringArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                String item = stringArray[n2];
                try {
                    Integer ion = Integer.parseInt(item);
                    ions.add(ion);
                }
                catch (NumberFormatException e) {
                    logger.warn((Object)e);
                }
                ++n2;
            }
        }
        return ions;
    }

    private Set<String> getIonSet(String[] items) {
        HashSet<String> ionSet = new HashSet<String>();
        if (items != null) {
            int size = items.length;
            int i = 0;
            while (i < size) {
                ionSet.add(items[i]);
                ++i;
            }
        }
        return ionSet;
    }
}

