/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.csd.converter.supplier.jcampdx.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import org.eclipse.chemclipse.converter.exceptions.FileIsEmptyException;
import org.eclipse.chemclipse.converter.exceptions.FileIsNotReadableException;
import org.eclipse.chemclipse.csd.converter.io.AbstractChromatogramCSDReader;
import org.eclipse.chemclipse.csd.converter.supplier.jcampdx.model.VendorChromatogram;
import org.eclipse.chemclipse.csd.converter.supplier.jcampdx.model.VendorScan;
import org.eclipse.chemclipse.csd.model.core.IChromatogramCSD;
import org.eclipse.chemclipse.csd.model.core.IScanCSD;
import org.eclipse.chemclipse.csd.model.core.identifier.scan.IScanTargetCSD;
import org.eclipse.chemclipse.csd.model.implementation.ScanTargetCSD;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.core.IChromatogramOverview;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.model.exceptions.ReferenceMustNotBeNullException;
import org.eclipse.chemclipse.model.identifier.ComparisonResult;
import org.eclipse.chemclipse.model.identifier.IComparisonResult;
import org.eclipse.chemclipse.model.identifier.ILibraryInformation;
import org.eclipse.chemclipse.model.identifier.LibraryInformation;
import org.eclipse.core.runtime.IProgressMonitor;

public class ChromatogramReader
extends AbstractChromatogramCSDReader {
    private static final Logger logger = Logger.getLogger(ChromatogramReader.class);
    private static final String HEADER_TITLE = "##TITLE=";
    private static final String HEADER_PROGRAM = "##PROGRAM=";
    private static final String RETENTION_TIME_MARKER = "##RETENTION_TIME=";
    private static final String TIME_MARKER = "##TIME=";
    private static final String TIC_MARKER = "##TIC=";
    private static final String NAME_MARKER = "##NAME=";
    private static final String HIT_MARKER = "##HIT=";
    private static final String XYDATA_MARKER_SPACE = "##XYDATA= (XY..XY)";
    private static final String XYDATA_MARKER_SHORT = "##XYDATA=(X,Y)";
    private static final String HEADER_MARKER = "##";

    public IChromatogramCSD read(File file, IProgressMonitor monitor) throws FileNotFoundException, FileIsNotReadableException, FileIsEmptyException, IOException {
        if (this.isValidFileFormat(file)) {
            return this.readChromatogram(file, monitor);
        }
        return null;
    }

    public IChromatogramOverview readOverview(File file, IProgressMonitor monitor) throws FileNotFoundException, FileIsNotReadableException, FileIsEmptyException, IOException {
        if (this.isValidFileFormat(file)) {
            return this.readChromatogram(file, monitor);
        }
        return null;
    }

    private IChromatogramCSD readChromatogram(File file, IProgressMonitor monitor) throws IOException {
        String line;
        VendorChromatogram chromatogram = new VendorChromatogram();
        FileReader fileReader = new FileReader(file);
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        String name = "";
        while ((line = bufferedReader.readLine()) != null) {
            int retentionTime;
            if (line.startsWith(NAME_MARKER)) {
                name = line.trim().replace(NAME_MARKER, "");
                continue;
            }
            if (!line.startsWith(TIC_MARKER)) continue;
            float abundance = 0.0f;
            try {
                String value = line.replace(TIC_MARKER, "").trim();
                abundance = Float.parseFloat(value);
            }
            catch (NumberFormatException e) {
                logger.warn((Object)e);
            }
            boolean searchForRetentionTime = true;
            while (searchForRetentionTime) {
                line = bufferedReader.readLine();
                if (line == null || !this.isRetentionTimeMarker(line)) continue;
                searchForRetentionTime = false;
            }
            if (line != null && (retentionTime = this.getRetentionTime(line)) >= 0 && abundance > 0.0f) {
                VendorScan scan = new VendorScan(abundance);
                scan.setRetentionTime(retentionTime);
                chromatogram.addScan((IScan)scan);
                if (!name.equals("")) {
                    boolean findHitMarker = true;
                    float matchFactor = 100.0f;
                    while ((line = bufferedReader.readLine()) != null && findHitMarker) {
                        if (line.startsWith(HIT_MARKER)) {
                            try {
                                String hitValue = line.replace(HIT_MARKER, "").trim();
                                matchFactor = Float.parseFloat(hitValue);
                                findHitMarker = false;
                            }
                            catch (NumberFormatException e) {
                                logger.warn((Object)e);
                            }
                            continue;
                        }
                        if (!line.startsWith(NAME_MARKER) && !line.startsWith(TIC_MARKER)) continue;
                        findHitMarker = false;
                    }
                    try {
                        LibraryInformation libraryInformation = new LibraryInformation();
                        libraryInformation.setName(name);
                        ComparisonResult comparisonResult = new ComparisonResult(matchFactor, matchFactor, 0.0f, 0.0f);
                        ScanTargetCSD scanTargetCSD = new ScanTargetCSD((ILibraryInformation)libraryInformation, (IComparisonResult)comparisonResult);
                        scanTargetCSD.setParentScan((IScanCSD)scan);
                        scan.addTarget((IScanTargetCSD)scanTargetCSD);
                    }
                    catch (ReferenceMustNotBeNullException e) {
                        logger.warn((Object)e);
                    }
                }
            }
            name = "";
        }
        int scanDelay = chromatogram.getScan(1).getRetentionTime();
        chromatogram.setScanDelay(scanDelay);
        int scanInterval = chromatogram.getStartRetentionTime() / chromatogram.getNumberOfScans();
        chromatogram.setScanInterval(scanInterval);
        chromatogram.setFile(file);
        chromatogram.setConverterId("org.eclipse.chemclipse.csd.converter.supplier.jcampdx");
        bufferedReader.close();
        fileReader.close();
        return chromatogram;
    }

    private boolean isRetentionTimeMarker(String line) {
        return line.startsWith(RETENTION_TIME_MARKER) || line.startsWith(TIME_MARKER);
    }

    private int getRetentionTime(String line) {
        int retentionTime = -1;
        try {
            if (line.startsWith(RETENTION_TIME_MARKER)) {
                String value = line.replace(RETENTION_TIME_MARKER, "").trim();
                retentionTime = (int)(Double.parseDouble(value) * 1000.0);
            } else if (line.startsWith(TIME_MARKER)) {
                String value = line.replace(TIME_MARKER, "").trim();
                retentionTime = (int)(Double.parseDouble(value) * 60000.0);
            }
        }
        catch (NumberFormatException e) {
            logger.warn((Object)e);
        }
        return retentionTime;
    }

    private boolean isValidFileFormat(File file) throws IOException {
        boolean isValidFormat = true;
        FileReader fileReader = new FileReader(file);
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        String line = bufferedReader.readLine();
        if (line.startsWith(HEADER_TITLE) || line.startsWith(HEADER_PROGRAM)) {
            boolean readIons = false;
            while ((line = bufferedReader.readLine()) != null) {
                if (line.startsWith(XYDATA_MARKER_SPACE) || line.startsWith(XYDATA_MARKER_SHORT)) {
                    readIons = true;
                    continue;
                }
                if (line.startsWith(HEADER_MARKER) || !readIons) continue;
                isValidFormat = false;
                break;
            }
        }
        bufferedReader.close();
        fileReader.close();
        return isValidFormat;
    }
}

