/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.ui.swt;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.database.IQuantDatabase;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.database.controller.QuantitationSignalEntryEdit;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.ui.internal.provider.QuantitationSignalsContentProvider;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.ui.internal.provider.QuantitationSignalsLabelProvider;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.ui.internal.provider.QuantitationSignalsTableComparator;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.ui.internal.runnables.dialogs.QuantitationSignalEntryEditDialog;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.ui.swt.AbstractTableViewerUI;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.ui.swt.IQuantitationCompoundUpdater;
import org.eclipse.chemclipse.msd.model.core.quantitation.IQuantitationCompoundMSD;
import org.eclipse.chemclipse.msd.model.core.quantitation.IQuantitationSignalMSD;
import org.eclipse.chemclipse.msd.model.core.quantitation.IQuantitationSignalsMSD;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class QuantitationSignalsUI
extends AbstractTableViewerUI
implements IQuantitationCompoundUpdater {
    private static final String MESSAGE_BOX_TEXT = "Quantitation Signal";
    private IQuantitationCompoundMSD quantitationCompoundDocument;

    public QuantitationSignalsUI(Composite parent, int style) {
        parent.setLayout((Layout)new FillLayout());
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        this.addList(composite);
        this.addButtons(composite);
    }

    @Override
    public void update(IQuantitationCompoundMSD quantitationCompoundDocument, IQuantDatabase database) {
        this.quantitationCompoundDocument = quantitationCompoundDocument;
        if (quantitationCompoundDocument == null) {
            this.getTableViewer().setInput(null);
        } else {
            this.setTableViewerInput();
        }
    }

    private void setTableViewerInput() {
        this.getTableViewer().setInput((Object)this.quantitationCompoundDocument);
    }

    private void addList(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gridDataTable = new GridData(1808);
        composite.setLayout((Layout)new GridLayout(1, true));
        composite.setLayoutData((Object)gridDataTable);
        String[] titles = new String[]{"Ion", "Relative Response", "Uncertainty", "Use"};
        int[] bounds = new int[]{100, 100, 100, 100};
        QuantitationSignalsContentProvider contentProvider = new QuantitationSignalsContentProvider();
        QuantitationSignalsLabelProvider labelProvider = new QuantitationSignalsLabelProvider();
        QuantitationSignalsTableComparator viewerTableComparator = new QuantitationSignalsTableComparator();
        this.createTableViewer(composite, gridDataTable, contentProvider, (LabelProvider)labelProvider, viewerTableComparator, titles, bounds);
        this.setTableViewerInput();
    }

    private void addButtons(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, true));
        GridData gridDataButtons = new GridData(1040);
        gridDataButtons.verticalAlignment = 128;
        composite.setLayoutData((Object)gridDataButtons);
        GridData gridData = new GridData(768);
        this.addButtonAdd(composite, gridData);
        this.addButtonEdit(composite, gridData);
        this.addButtonRemove(composite, gridData);
        this.addButtonRemoveAll(composite, gridData);
    }

    private void addButtonAdd(Composite parent, GridData gridData) {
        Button button = new Button(parent, 8);
        button.setLayoutData((Object)gridData);
        button.setText("Add");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (QuantitationSignalsUI.this.quantitationCompoundDocument != null) {
                    IQuantitationSignalMSD quantitationSignalMSD;
                    QuantitationSignalEntryEdit quantitationSignalEntryEdit;
                    Shell shell = Display.getCurrent().getActiveShell();
                    QuantitationSignalEntryEditDialog dialog = new QuantitationSignalEntryEditDialog(shell, quantitationSignalEntryEdit = new QuantitationSignalEntryEdit(), "Create a new quantitation signal.");
                    if (dialog.open() == 0 && (quantitationSignalMSD = quantitationSignalEntryEdit.getQuantitationSignalMSD()) != null) {
                        QuantitationSignalsUI.this.quantitationCompoundDocument.getQuantitationSignalsMSD().add(quantitationSignalMSD);
                        QuantitationSignalsUI.this.setTableViewerInput();
                    }
                } else {
                    QuantitationSignalsUI.this.showMessage(QuantitationSignalsUI.MESSAGE_BOX_TEXT, "Please select a quantitation compound previously.");
                }
            }
        });
    }

    private void addButtonEdit(Composite parent, GridData gridData) {
        Button button = new Button(parent, 8);
        button.setLayoutData((Object)gridData);
        button.setText("Edit");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (QuantitationSignalsUI.this.quantitationCompoundDocument != null) {
                    IQuantitationSignalMSD quantitationSignalOld = QuantitationSignalsUI.this.getSelectedQuantitationSignalMSD();
                    if (quantitationSignalOld != null) {
                        Shell shell = Display.getCurrent().getActiveShell();
                        QuantitationSignalEntryEdit quantitationSignalEntryEdit = new QuantitationSignalEntryEdit();
                        quantitationSignalEntryEdit.setQuantitationSignalMSD(quantitationSignalOld);
                        QuantitationSignalEntryEditDialog dialog = new QuantitationSignalEntryEditDialog(shell, quantitationSignalEntryEdit, "Edit the quantitation signal.");
                        if (dialog.open() == 0) {
                            IQuantitationSignalMSD quantitationSignalNew = quantitationSignalEntryEdit.getQuantitationSignalMSD();
                            if (quantitationSignalOld != null) {
                                IQuantitationSignalsMSD quantitationSignalsMSD = QuantitationSignalsUI.this.quantitationCompoundDocument.getQuantitationSignalsMSD();
                                quantitationSignalsMSD.remove(quantitationSignalOld);
                                quantitationSignalsMSD.add(quantitationSignalNew);
                                QuantitationSignalsUI.this.quantitationCompoundDocument.updateQuantitationSignalsMSD(quantitationSignalsMSD);
                                QuantitationSignalsUI.this.setTableViewerInput();
                            }
                        }
                    } else {
                        QuantitationSignalsUI.this.showMessage(QuantitationSignalsUI.MESSAGE_BOX_TEXT, "Please select a quantitation signal.");
                    }
                } else {
                    QuantitationSignalsUI.this.showMessage(QuantitationSignalsUI.MESSAGE_BOX_TEXT, "Please select a quantitation compound previously.");
                }
            }
        });
    }

    private void addButtonRemove(Composite parent, GridData gridData) {
        Button button = new Button(parent, 8);
        button.setLayoutData((Object)gridData);
        button.setText("Delete");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List quantitationSignalsMSD = QuantitationSignalsUI.this.getSelectedQuantitationSignalsMSD();
                if (quantitationSignalsMSD.size() > 0) {
                    int decision = QuantitationSignalsUI.this.showQuestion(QuantitationSignalsUI.MESSAGE_BOX_TEXT, "Would you like to delete the selected quantitation signals?");
                    if (decision == 64) {
                        QuantitationSignalsUI.this.quantitationCompoundDocument.getQuantitationSignalsMSD().removeAll(quantitationSignalsMSD);
                        QuantitationSignalsUI.this.setTableViewerInput();
                    }
                } else {
                    QuantitationSignalsUI.this.showMessage(QuantitationSignalsUI.MESSAGE_BOX_TEXT, "Please select quantitation signals to delete.");
                }
            }
        });
    }

    private void addButtonRemoveAll(Composite parent, GridData gridData) {
        Button button = new Button(parent, 8);
        button.setLayoutData((Object)gridData);
        button.setText("Delete All");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int decision = QuantitationSignalsUI.this.showQuestion(QuantitationSignalsUI.MESSAGE_BOX_TEXT, "Would you like to delete all response entry?");
                if (decision == 64) {
                    QuantitationSignalsUI.this.quantitationCompoundDocument.getQuantitationSignalsMSD().clear();
                    QuantitationSignalsUI.this.setTableViewerInput();
                }
            }
        });
    }

    private IQuantitationSignalMSD getSelectedQuantitationSignalMSD() {
        IQuantitationSignalMSD quantitationSignalMSD = null;
        Object element = this.getSelectedTableItem();
        if (element instanceof IQuantitationSignalMSD) {
            quantitationSignalMSD = (IQuantitationSignalMSD)element;
        }
        return quantitationSignalMSD;
    }

    private List<IQuantitationSignalMSD> getSelectedQuantitationSignalsMSD() {
        ArrayList<IQuantitationSignalMSD> quantitationSignalsMSD = new ArrayList<IQuantitationSignalMSD>();
        List<Object> elements = this.getSelectedTableItems();
        for (Object element : elements) {
            if (!(element instanceof IQuantitationSignalMSD)) continue;
            IQuantitationSignalMSD quantitationSignalMSD = (IQuantitationSignalMSD)element;
            quantitationSignalsMSD.add(quantitationSignalMSD);
        }
        return quantitationSignalsMSD;
    }
}

